/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

import com.phono.srtplight.BitUtils;
import com.phono.srtplight.Log;
import com.phono.srtplight.RTPDataSink;
import com.phono.srtplight.RTPPacketException;
import com.phono.srtplight.RTPProtocolFace;
import com.phono.srtplight.SRTPProtocolImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;

public class RTPProtocolImpl
extends BitUtils
implements RTPProtocolFace {
    static final int RTPHEAD = 12;
    private static final int RTPVER = 2;
    static final Random _rand = new SecureRandom();
    private RTPDataSink _rtpds;
    private long _sync = -1L;
    protected long _index;
    private boolean _first;
    protected long _roc = 0L;
    protected char _s_l;
    DatagramSocket _ds;
    SocketAddress _far;
    protected Thread _listen;
    String _session;
    protected boolean _srtp = false;
    int _id;
    int _ptype;
    long _seqno;
    protected long _csrcid;
    protected int _tailIn;
    protected int _tailOut;
    private int _dtmfType = 101;
    private Exception _lastx;
    private boolean _realloc = false;
    private long[] csrc;
    private byte[] extens;
    private Character extype;

    public RTPProtocolImpl(int id, DatagramSocket ds, InetSocketAddress far, int type) {
        this._ds = ds;
        this._far = far;
        this._id = id;
        this._ptype = type;
        this._session = "RTPSession" + id;
        this._seqno = 0L;
        this._csrcid = _rand.nextInt();
        if (this._ds != null) {
            try {
                if (this._far != null && !far.getAddress().isLoopbackAddress()) {
                    this._ds.connect(this._far);
                }
                this._ds.setSoTimeout(100);
            }
            catch (SocketException ex) {
                Log.warn("Problem with datagram socket:" + ex.getMessage());
            }
        } else {
            Log.verb("RTPProtocolImpl with no datagram socket");
        }
        if (this._ds != null) {
            Runnable ir = new Runnable(){

                @Override
                public void run() {
                    RTPProtocolImpl.this.irun();
                }
            };
            this._listen = new Thread(ir);
            this._listen.setName(this._session);
        }
        this._first = true;
        Log.debug("RTP session " + this.getClass().getSimpleName() + this._session);
    }

    public byte[] getExtens() {
        return this.extens;
    }

    public Character getExtype() {
        return this.extype;
    }

    public void setSSRC(long v) {
        this._csrcid = v;
    }

    public RTPProtocolImpl(int id, String local_media_address, int local_audio_port, String remote_media_address, int remote_audio_port, int type) throws SocketException {
        this(id, new DatagramSocket(local_audio_port), new InetSocketAddress(remote_media_address, remote_audio_port), type);
    }

    @Override
    public void setRealloc(boolean v) {
        this._realloc = v;
    }

    protected void irun() {
        byte[] data = new byte[1490];
        DatagramPacket dp = new DatagramPacket(data, data.length);
        Log.debug("Max Datagram size " + data.length);
        Log.debug("address is  " + this._ds.getLocalSocketAddress().toString());
        long count = 0L;
        while (this._listen != null) {
            try {
                Log.verb("rtp loop");
                this._ds.receive(dp);
                this.parsePacket(dp);
                ++count;
                if (!this._realloc) continue;
                data = new byte[1490];
                dp = new DatagramPacket(data, data.length);
            }
            catch (SocketTimeoutException x) {
                if (count <= 0L) continue;
                Log.debug("Timeout waiting for packet");
            }
            catch (IOException ex) {
                Log.debug(this.getClass().getSimpleName() + " " + ex.toString());
                this._lastx = ex;
            }
        }
        if (!this._ds.isClosed()) {
            this._ds.close();
        }
    }

    @Override
    public void setRTPDataSink(RTPDataSink ds) {
        this._rtpds = ds;
    }

    @Override
    public void terminate() {
        this._listen = null;
    }

    static long get4ByteInt(byte[] b, int offs) {
        return b[offs++] << 24 | b[offs++] << 16 | b[offs++] << 8 | 0xFF & b[offs++];
    }

    @Override
    public void sendPacket(byte[] data, long stamp, int ptype) throws SocketException, IOException {
        this.sendPacket(data, stamp, ptype, false);
    }

    public long getIndex() {
        return this._index;
    }

    public long getSeqno() {
        return this._seqno;
    }

    public Exception getNClearLastX() {
        Exception ret = this._lastx;
        ret = null;
        return ret;
    }

    public void sendPacket(byte[] data, long stamp, int ptype, boolean marker) throws IOException {
        this.sendPacket(data, stamp, (char)this._seqno, ptype, marker);
        ++this._seqno;
    }

    public void sendPacket(byte[] data, long stamp, char seqno, int ptype, boolean marker) throws IOException {
        try {
            byte[] payload = new byte[12 + data.length + this._tailOut];
            RTPProtocolImpl.copyBits(2, 2, payload, 0);
            if (marker) {
                RTPProtocolImpl.copyBits(1, 1, payload, 8);
            }
            RTPProtocolImpl.copyBits(ptype, 7, payload, 9);
            payload[2] = (byte)(seqno >> 8);
            payload[3] = (byte)seqno;
            payload[4] = (byte)(stamp >> 24);
            payload[5] = (byte)(stamp >> 16);
            payload[6] = (byte)(stamp >> 8);
            payload[7] = (byte)stamp;
            payload[8] = (byte)(this._csrcid >> 24);
            payload[9] = (byte)(this._csrcid >> 16);
            payload[10] = (byte)(this._csrcid >> 8);
            payload[11] = (byte)this._csrcid;
            for (int i = 0; i < data.length; ++i) {
                payload[i + 12] = data[i];
            }
            this.appendAuth(payload);
            this.sendToNetwork(payload);
            Log.verb("sending RTP " + this._ptype + " packet length " + payload.length + "seq =" + seqno + " csrc=" + this._csrcid + " stamp=" + stamp);
        }
        catch (IOException ex) {
            this._lastx = ex;
            Log.error("Not sending RTP " + this._ptype + "ex = " + ex.getMessage());
            throw ex;
        }
    }

    protected void sendToNetwork(byte[] payload) throws IOException {
        DatagramPacket p = this._far == null ? new DatagramPacket(payload, payload.length) : new DatagramPacket(payload, payload.length, this._far);
        this._ds.send(p);
    }

    protected void parsePacket(DatagramPacket dp) throws IOException {
        int i;
        byte[] packet = dp.getData();
        int plen = dp.getLength();
        short ver = 0;
        short pad = 0;
        int csrcn = 0;
        short mark = 0;
        short ptype = 0;
        char seqno = '\u0000';
        long stamp = 0L;
        int sync = 0;
        short x = 0;
        char exlen = '\u0000';
        Log.verb("got packet " + plen);
        if (plen < 12) {
            throw new RTPPacketException("Packet too short. RTP must be >12 bytes");
        }
        ver = RTPProtocolImpl.copyBits(packet, 0, 2);
        pad = RTPProtocolImpl.copyBits(packet, 2, 1);
        x = RTPProtocolImpl.copyBits(packet, 3, 1);
        csrcn = RTPProtocolImpl.copyBits(packet, 4, 4);
        mark = RTPProtocolImpl.copyBits(packet, 8, 1);
        ptype = RTPProtocolImpl.copyBits(packet, 9, 7);
        ByteBuffer pb = ByteBuffer.wrap(packet);
        seqno = pb.getChar(2);
        stamp = RTPProtocolImpl.getUnsignedInt(pb, 4);
        sync = pb.getInt(8);
        if (plen < 12 + 4 * csrcn) {
            throw new RTPPacketException("Packet too short. CSRN =" + csrcn + " but packet only " + plen);
        }
        this.csrc = new long[csrcn];
        int offs = 12;
        for (i = 0; i < csrcn; ++i) {
            this.csrc[i] = RTPProtocolImpl.getUnsignedInt(pb, offs);
            offs += 4;
        }
        if (x > 0) {
            this.extype = new Character(pb.getChar(offs));
            exlen = pb.getChar(offs += 2);
            offs += 2;
            Log.verb("skip an extension 0x" + Integer.toHexString(this.extype.charValue()) + " length " + exlen);
            this.extens = new byte[4 * exlen];
            for (i = 0; i < this.extens.length; ++i) {
                this.extens[i] = packet[offs++];
            }
        } else {
            this.extype = null;
        }
        int endhead = offs;
        int paylen = pad == 0 ? plen - offs : plen - offs - 255 & packet[plen - 1];
        byte[] payload = new byte[paylen -= this._tailIn];
        int o = 0;
        while (offs - endhead < paylen) {
            payload[o++] = packet[offs++];
        }
        if (ver != 2) {
            throw new RTPPacketException("Only RTP version 2 supported");
        }
        if (ptype != this._ptype) {
            throw new RTPPacketException("Unexpected payload type " + ptype);
        }
        if ((long)sync != this._sync) {
            this.syncChanged(sync);
        }
        this._index = this.getIndex(seqno);
        try {
            this.updateCounters(seqno);
            this.checkAuth(packet, plen);
        }
        catch (RTPPacketException rpx) {
            Log.debug("Failed packet sync = " + ('\u0000' + seqno));
            Log.debug("index is = " + this._index);
            if (this instanceof SRTPProtocolImpl) {
                Log.debug("roc is = " + ((SRTPProtocolImpl)this)._roc);
            }
            throw rpx;
        }
        this.deliverPayload(payload, stamp, sync, seqno, mark);
        Log.verb("got RTP " + ptype + " packet " + payload.length);
    }

    void checkAuth(byte[] packet, int plen) throws RTPPacketException {
    }

    long getIndex(char seqno) {
        long v = this._roc;
        int diff = seqno - this._s_l;
        if (diff < Short.MIN_VALUE) {
            v = this._roc + 1L;
        }
        if (diff > Short.MAX_VALUE) {
            v = this._roc - 1L;
        }
        if (v < 0L) {
            v = 0L;
        }
        long low = seqno;
        long high = v << 16;
        long ret = low | high;
        return ret;
    }

    protected void deliverPayload(byte[] payload, long stamp, int ssrc, char seqno) {
        if (this._rtpds != null) {
            this._rtpds.dataPacketReceived(payload, stamp, this.getIndex(seqno));
        }
    }

    void appendAuth(byte[] payload, char seqno) throws RTPPacketException {
    }

    void appendAuth(byte[] payload) throws RTPPacketException {
    }

    void updateCounters(char seqno) {
        int diff = seqno - this._s_l;
        if (seqno == '\u0000') {
            Log.debug("seqno = 0 _index =" + this._index + " _roc =" + this._roc + " _s_l= " + ('\u0000' + this._s_l) + " diff = " + diff + " mins=-32768");
        }
        if (diff < Short.MIN_VALUE) {
            ++this._roc;
        }
        this._s_l = seqno;
    }

    protected void syncChanged(long sync) throws RTPPacketException {
        if (this._sync != -1L) {
            throw new RTPPacketException("Sync changed: was " + this._sync + " now " + sync);
        }
        this._sync = sync;
    }

    public static long getUnsignedInt(ByteBuffer bb, int loc) {
        return (long)bb.getInt(loc) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer bb, long value2, int loc) {
        bb.putInt(loc, (int)(value2 & 0xFFFFFFFFL));
    }

    @Override
    public void startrecv() {
        this._listen.start();
    }

    public DatagramSocket getDS() {
        return this._ds;
    }

    @Override
    public boolean finished() {
        return this._listen == null;
    }

    @Override
    public void sendDigit(String value2, long stamp, int samples, int duration) throws SocketException, IOException {
        int sp = 0;
        int end = 0;
        int db = 3;
        char c = value2.toUpperCase().charAt(0);
        if (c >= '0' && c <= '9') {
            sp = c - 48;
        } else {
            if (c == '#') {
                sp = 11;
            }
            if (c == '*') {
                sp = 10;
            }
        }
        if (c >= 'A' && c <= 'D') {
            sp = 12 + (c - 65);
        }
        byte[] data = new byte[4];
        RTPProtocolImpl.copyBits(sp, 8, data, 0);
        RTPProtocolImpl.copyBits(end, 0, data, 8);
        RTPProtocolImpl.copyBits(db, 6, data, 10);
        RTPProtocolImpl.copyBits(samples, 16, data, 16);
        this.sendDTMFData(data, stamp, true);
        long count = duration / 20 - 1;
        int i = 0;
        while ((long)i < count) {
            try {
                Thread.sleep(10L);
                this.sendDTMFData(data, stamp, false);
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                Log.verb(ex.getMessage());
            }
            ++i;
        }
        end = 1;
        RTPProtocolImpl.copyBits(end, 1, data, 8);
        this.sendDTMFData(data, stamp, false);
        this.sendDTMFData(data, stamp, false);
        this.sendDTMFData(data, stamp, false);
    }

    public boolean sendDTMFData(byte[] data, long stamp, boolean mark) throws SocketException, IOException {
        boolean ret = false;
        this.sendPacket(data, stamp, this._dtmfType, mark);
        ret = true;
        return ret;
    }

    @Override
    public void setDTMFPayloadType(int type) {
        this._dtmfType = type;
    }

    protected void deliverPayload(byte[] payload, long stamp, int sync, char seqno, int mark) {
        this.deliverPayload(payload, stamp, sync, seqno);
    }

    public static void main(String[] args) {
        long stamp;
        byte[] data = new byte[1209];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(data);
        final DatagramPacket[] dsa = new DatagramPacket[1];
        final long[] gstamp = new long[1];
        final long[] gindex = new long[1];
        try {
            DatagramSocket ds = new DatagramSocket(){

                @Override
                public void send(DatagramPacket dp) throws IOException {
                    dsa[0] = dp;
                }
            };
            int id = sr.nextInt(65535);
            int type = sr.nextInt(127);
            RTPProtocolImpl target = new RTPProtocolImpl(id, ds, null, type);
            RTPDataSink rtpds = new RTPDataSink(){

                @Override
                public void dataPacketReceived(byte[] data, long stamp, long index) {
                    gstamp[0] = stamp;
                    gindex[0] = index;
                }
            };
            target.setRTPDataSink(rtpds);
            for (stamp = 0L; stamp < 0x200000000L; ++stamp) {
                target.sendPacket(data, stamp, type);
                target.parsePacket(dsa[0]);
                if (gstamp[0] != stamp) {
                    throw new ArithmeticException("Stamp is wrong " + gstamp[0] + " != " + stamp);
                }
                long xindex = stamp;
                if (gindex[0] != xindex) {
                    throw new ArithmeticException("Index is wrong " + gindex[0] + " != " + xindex);
                }
                if (stamp % 0x1000000L != 0L) continue;
                System.out.println("did " + stamp + " tests");
            }
        }
        catch (Exception x) {
            System.out.println("exception " + x.getLocalizedMessage());
            x.printStackTrace();
        }
        System.out.println("did " + stamp + " tests");
    }
}

