/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

import biz.source_code.Base64Coder;
import com.phono.srtplight.Log;
import com.phono.srtplight.SRTPProtocolImpl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SRTPSecContext {
    static int KEYLEN = 16;
    static int MACKEYLEN = 20;
    static int BLOCKSZ = 16;
    private Cipher _anAES;
    protected byte[] _sessionKey = new byte[0];
    ByteBuffer _masterSalt;
    protected byte[] _cipherSalt;
    protected byte[] _sessionAuth;
    private int _tag;
    private int _authTail;
    byte[] _masterKey;
    private int _mki;
    private int _mkiLen;
    private int _kdr;
    private int _keyLife;
    private boolean _doAuth;
    private boolean _doCrypt;
    private boolean _in;
    protected String _dirn;

    SRTPSecContext(boolean in) {
        this._in = in;
        this._dirn = in ? "in " : "out ";
    }

    SRTPSecContext() {
        this(false);
    }

    static byte[] saba(short[] s2) {
        byte[] r = new byte[s2.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)s2[i];
        }
        return r;
    }

    public int getAuthTail() {
        return this._authTail;
    }

    public static void main(String[] argv) {
        SRTPSecContext s2 = new SRTPSecContext();
        try {
            System.out.println("test key derivation");
            s2.testDeriv();
            s2.testHmac();
        }
        catch (GeneralSecurityException ex) {
            System.out.println("Failed ");
            ex.printStackTrace();
        }
    }

    private void testResult(byte[] a, byte[] b) throws GeneralSecurityException {
        if (a.length != b.length) {
            throw new GeneralSecurityException("lengths dont match " + a.length + " != " + b.length);
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            throw new GeneralSecurityException("values " + i + " dont match " + a[i] + " != " + b[i]);
        }
    }

    private void testHmac() throws GeneralSecurityException {
        short[] hmac_test_case_0_keyS = new short[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
        short[] hmac_test_case_0_dataS = new short[]{72, 105, 32, 84, 104, 101, 114, 101};
        short[] hmac_test_case_0_tagS = new short[]{182, 23, 49, 134, 85, 5, 114, 100, 226, 139, 192, 182, 251, 55, 140, 142, 241, 70, 190, 0};
        System.err.println("test hmac ");
        byte[] hmac_test_case_0_key = SRTPSecContext.saba(hmac_test_case_0_keyS);
        byte[] hmac_test_case_0_data = SRTPSecContext.saba(hmac_test_case_0_dataS);
        byte[] hmac_test_case_0_tag = SRTPSecContext.saba(hmac_test_case_0_tagS);
        this._sessionAuth = hmac_test_case_0_key;
        Mac m = this.getAuthMac();
        byte[] res = m.doFinal(hmac_test_case_0_data);
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == hmac_test_case_0_tag[i]) continue;
            throw new GeneralSecurityException("auth mac failed selftest ");
        }
    }

    private void testDeriv() throws GeneralSecurityException {
        short[] masterkeyS = new short[]{225, 249, 122, 13, 62, 1, 139, 224, 214, 79, 163, 44, 6, 222, 65, 57};
        short[] mastersaltS = new short[]{14, 198, 117, 173, 73, 138, 254, 235, 182, 150, 11, 58, 171, 230};
        short[] plaintextS = new short[]{14, 198, 117, 173, 73, 138, 254, 235, 182, 150, 11, 58, 171, 230, 0, 0};
        short[] reskeyS = new short[]{198, 30, 122, 147, 116, 79, 57, 238, 16, 115, 74, 254, 63, 247, 160, 135};
        short[] csaltS = new short[]{48, 203, 188, 8, 134, 61, 140, 133, 212, 157, 179, 74, 154, 225, 122, 198};
        short[] authKeyS = new short[]{206, 190, 50, 31, 111, 247, 113, 107, 111, 212, 171, 73, 175, 37, 106, 21, 109, 56, 186, 164};
        this._masterKey = SRTPSecContext.saba(masterkeyS);
        byte[] mastersalt = SRTPSecContext.saba(mastersaltS);
        this._masterSalt = ByteBuffer.allocate(16);
        this._masterSalt.put(mastersalt);
        byte[] plaintext = SRTPSecContext.saba(plaintextS);
        byte[] reskey = SRTPSecContext.saba(reskeyS);
        byte[] csalt = SRTPSecContext.saba(csaltS);
        byte[] authkey = SRTPSecContext.saba(authKeyS);
        this.deriveKeys(0L, 0);
        System.err.println("test session key");
        this.testResult(this._sessionKey, reskey);
        System.err.println("test session salt");
        this.testResult(this._cipherSalt, csalt);
        System.err.println("test auth key");
        this.testResult(this._sessionAuth, authkey);
    }

    static void bbxor(ByteBuffer l, ByteBuffer r) {
        int num = Math.min(l.capacity(), r.capacity());
        for (int i = 0; i < num; ++i) {
            byte a = (byte)(r.get(i) ^ l.get(i));
            l.put(i, a);
        }
    }

    ByteBuffer cloneByteBuffer(ByteBuffer orig) {
        ByteBuffer ret = ByteBuffer.allocate(orig.capacity());
        ret.put(orig.array(), 0, orig.capacity());
        return ret;
    }

    void deriveKeys(long index) throws GeneralSecurityException {
        if (this.haveKeys() && this._kdr != 0 && index % (long)this._kdr == 0L) {
            this.deriveKeys(index, this._kdr);
        } else if (!this.haveKeys()) {
            this.deriveKeys(0L, 0);
        }
    }

    protected void deriveKeys(long index, int kdr) throws GeneralSecurityException {
        this.deriveKeys(index, kdr, 0, 2, 1);
    }

    protected void deriveKeys(long index, int kdr, int sess, int salt, int auth) throws GeneralSecurityException {
        byte label = (byte)sess;
        ByteBuffer myinpblk = this.cloneByteBuffer(this._masterSalt);
        ByteBuffer lex = ByteBuffer.allocate(BLOCKSZ);
        long idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPSecContext.bbxor(myinpblk, lex);
        this._sessionKey = this.getKeyBytes(myinpblk, KEYLEN);
        label = (byte)salt;
        myinpblk = this.cloneByteBuffer(this._masterSalt);
        lex = ByteBuffer.allocate(BLOCKSZ);
        idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPSecContext.bbxor(myinpblk, lex);
        this._cipherSalt = this.getKeyBytes(myinpblk, KEYLEN);
        this._cipherSalt[14] = 0;
        this._cipherSalt[15] = 0;
        label = (byte)auth;
        myinpblk = this.cloneByteBuffer(this._masterSalt);
        lex = ByteBuffer.allocate(BLOCKSZ);
        idivk = kdr == 0 ? 0L : index / (long)kdr;
        lex.putLong(6, idivk);
        lex.put(7, label);
        SRTPSecContext.bbxor(myinpblk, lex);
        this._sessionAuth = this.getKeyBytes(myinpblk, MACKEYLEN);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "Derive keys for index = " + index + " kdr =" + kdr);
            Log.verb(this._dirn + "Session Key = " + SRTPProtocolImpl.getHex(this._sessionKey));
            Log.verb(this._dirn + "CipherSalt Key = " + SRTPProtocolImpl.getHex(this._cipherSalt));
            Log.verb(this._dirn + "Auth Key = " + SRTPProtocolImpl.getHex(this._sessionAuth));
        }
    }

    void getCypherStreamBytes(Cipher aes, ByteBuffer asalt, ByteBuffer stream) throws GeneralSecurityException {
        char bno;
        int blocksz = 16;
        int toget = stream.capacity() - 32;
        ((Buffer)stream).position(0);
        char blks = toget / blocksz;
        for (bno = '\u0000'; bno < blks; bno = (char)(bno + '\u0001')) {
            asalt.putChar(14, bno);
            ((Buffer)asalt).position(0);
            aes.update(asalt, stream);
        }
        asalt.putChar(14, bno);
        ((Buffer)asalt).position(0);
        aes.doFinal(asalt, stream);
    }

    protected byte[] getKeyBytes(ByteBuffer inp, int want) throws GeneralSecurityException {
        int blocksz = 16;
        byte[] ret = null;
        if (want == blocksz) {
            ByteBuffer slop = ByteBuffer.allocate(want * 2);
            inp.putChar(14, '\u0000');
            ((Buffer)inp).position(0);
            this._anAES.doFinal(inp, slop);
            ret = new byte[want];
            ((Buffer)slop).position(0);
            slop.get(ret);
        } else {
            ByteBuffer stream = ByteBuffer.allocate(want + 32);
            this.getCypherStreamBytes(this._anAES, inp, stream);
            ret = new byte[want];
            System.arraycopy(stream.array(), 0, ret, 0, want);
        }
        return ret;
    }

    Mac getAuthMac() throws GeneralSecurityException {
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "getting Hmac key = " + SRTPProtocolImpl.getHex(this._sessionAuth));
        }
        SecretKeySpec key = new SecretKeySpec(this._sessionAuth, "HmacSHA1");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(key);
        return m;
    }

    void decipher(ByteBuffer in, ByteBuffer out, ByteBuffer pepper) throws GeneralSecurityException {
        SecretKeySpec keyp = new SecretKeySpec(this._sessionKey, "AES");
        Cipher aes = Cipher.getInstance("AES");
        aes.init(1, keyp);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: key    =" + SRTPProtocolImpl.getHex(this._sessionKey));
        }
        ByteBuffer csalt = ByteBuffer.wrap(this._cipherSalt);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: salt   =" + SRTPProtocolImpl.getHex(csalt.array()));
        }
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: pepper =" + SRTPProtocolImpl.getHex(pepper.array()));
        }
        SRTPSecContext.bbxor(pepper, csalt);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: IV     =" + SRTPProtocolImpl.getHex(pepper.array()));
        }
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: in     =" + SRTPProtocolImpl.getHex(in.array()));
        }
        this.getCypherStreamBytes(aes, pepper, out);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: stream =" + SRTPProtocolImpl.getHex(out.array()));
        }
        SRTPSecContext.bbxor(out, in);
        if (Log.getLevel() > 4) {
            Log.verb(this._dirn + "decipher: xor    =" + SRTPProtocolImpl.getHex(out.array()));
        }
    }

    boolean haveKeys() {
        return this._sessionAuth != null && this._sessionKey != null && this._cipherSalt != null;
    }

    static String stripQ(String s2) {
        String d = s2;
        if (s2 != null && s2.indexOf("'") == 0) {
            int lq = s2.lastIndexOf("'");
            d = s2.substring(1, lq);
        }
        return d;
    }

    void parseCryptoProps(Properties cryptoProps) throws GeneralSecurityException {
        String crypto_suite = SRTPSecContext.stripQ(cryptoProps.getProperty("crypto-suite"));
        String key_params = SRTPSecContext.stripQ(cryptoProps.getProperty("key-params"));
        String session_params = SRTPSecContext.stripQ(cryptoProps.getProperty("session-params"));
        String tag = SRTPSecContext.stripQ(cryptoProps.getProperty("tag"));
        if (crypto_suite.equals("AES_CM_128_HMAC_SHA1_80")) {
            this._authTail = 10;
        } else if (crypto_suite.equals("AES_CM_128_HMAC_SHA1_32")) {
            this._authTail = 4;
        } else {
            throw new GeneralSecurityException("Unsupported crypto suite " + crypto_suite);
        }
        if (key_params != null && key_params.startsWith("inline:")) {
            byte[] mks;
            String ks = key_params.substring("inline:".length());
            String mkil = null;
            String life = null;
            if (ks.indexOf("|") > 0) {
                String[] kbits = ks.split("\\|");
                ks = kbits[0];
                if (kbits.length > 1 && kbits[1].contains(":")) {
                    mkil = kbits[1];
                } else {
                    if (kbits.length > 1) {
                        life = kbits[1];
                    }
                    if (kbits.length > 2 && kbits[1].contains(":")) {
                        mkil = kbits[2];
                    }
                }
            }
            if ((mks = Base64Coder.decode(ks)).length != 30) {
                throw new GeneralSecurityException("Master ket/salt too short - expecting 30 got" + mks.length);
            }
            this._masterKey = new byte[16];
            System.arraycopy(mks, 0, this._masterKey, 0, this._masterKey.length);
            SecretKeySpec keyp = new SecretKeySpec(this._masterKey, "AES");
            this._anAES = Cipher.getInstance("AES");
            this._anAES.init(1, keyp);
            this._masterSalt = ByteBuffer.allocate(KEYLEN);
            this._masterSalt.put(mks, this._masterKey.length, 14);
            if (mkil != null) {
                String[] mbits = mkil.split("\\:");
                if (mbits.length == 2) {
                    this._mki = Integer.parseInt(mbits[0]);
                    this._mkiLen = Integer.parseInt(mbits[1]);
                    Log.warn(this._dirn + "MKI:length defined");
                } else {
                    throw new GeneralSecurityException("Expecting MKI:length");
                }
            }
            if (life != null) {
                if (life.contains("^")) {
                    String[] klb = life.split("\\^");
                    if (klb.length == 2) {
                        int f = Integer.parseInt(klb[0]);
                        int p = Integer.parseInt(klb[1]);
                        this._keyLife = f == 2 ? 1 << p : (int)Math.pow(f, p);
                    }
                } else {
                    this._keyLife = Integer.parseInt(life);
                }
                Log.warn("Key life is " + this._keyLife);
            }
        } else {
            throw new GeneralSecurityException("Missing inline key/salt in SDP");
        }
        if (session_params != null) {
            String[] sbits = session_params.split(" ");
            for (int i = 0; i < sbits.length; ++i) {
                Log.debug(this._dirn + "SDP session param " + sbits[i]);
                if (sbits[i].startsWith("KDR=")) {
                    String kdrs = sbits[i].substring("KDR=".length());
                    this._kdr = Integer.parseInt(kdrs);
                    Log.debug(this._dirn + "setting kdr to " + this._kdr);
                    if (this._kdr != 0) {
                        Log.debug(this._dirn + "Note: Non-zero kdr");
                    }
                }
                if ("UNENCRYPTED_SRTP".equals(sbits[i])) {
                    this._doCrypt = false;
                    Log.warn(this._dirn + "Switching off encryption - is this what you wanted ?");
                }
                if ("UNENCRYPTED_SRTCP".equals(sbits[i])) {
                    Log.debug(this._dirn + "No support for SRTCP (yet) so SDP setting ignored");
                }
                if ("UNAUTHENTICATED_SRTP".equals(sbits[i])) {
                    this._doAuth = false;
                }
                if ("FEC_ORDER".equals(sbits[i])) {
                    // empty if block
                }
                if ("FEC_KEY".equals(sbits[i])) {
                    // empty if block
                }
                if (!"WSH".equals(sbits[i])) continue;
            }
        }
        if (tag != null) {
            this._tag = Integer.parseInt(tag);
            Log.debug(this._dirn + "SDP tag = " + this._tag);
        }
    }
}

