/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.bootstrap.geyser;

import com.rtm516.mcxboxbroadcast.core.Logger;
import org.geysermc.geyser.api.extension.ExtensionLogger;

public class ExtensionLoggerImpl
implements Logger {
    private final ExtensionLogger logger;
    private final String prefixString;

    public ExtensionLoggerImpl(ExtensionLogger logger) {
        this(logger, "");
    }

    public ExtensionLoggerImpl(ExtensionLogger logger, String prefixString) {
        this.logger = logger;
        this.prefixString = prefixString;
    }

    @Override
    public void info(String message) {
        this.logger.info(this.prefix(message));
    }

    @Override
    public void warn(String message) {
        this.logger.warning(this.prefix(message));
    }

    @Override
    public void error(String message) {
        this.logger.error(this.prefix(message));
    }

    @Override
    public void error(String message, Throwable ex) {
        this.logger.error(this.prefix(message), ex);
    }

    @Override
    public void debug(String message) {
        this.logger.debug(this.prefix(message));
    }

    @Override
    public Logger prefixed(String prefixString) {
        return new ExtensionLoggerImpl(this.logger, prefixString);
    }

    private String prefix(String message) {
        if (this.prefixString.isEmpty()) {
            return message;
        }
        return "[" + this.prefixString + "] " + message;
    }
}

