/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.bootstrap.geyser;

import com.rtm516.mcxboxbroadcast.bootstrap.geyser.ConfigLoader;
import com.rtm516.mcxboxbroadcast.bootstrap.geyser.ExtensionLoggerImpl;
import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.SessionManager;
import com.rtm516.mcxboxbroadcast.core.configs.ExtensionConfig;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionCreationException;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionUpdateException;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;
import com.rtm516.mcxboxbroadcast.core.notifications.SlackNotificationManager;
import com.rtm516.mcxboxbroadcast.core.storage.FileStorageManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.event.connection.GeyserBedrockPingEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCommandsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.extension.Extension;

public class MCXboxBroadcastExtension
implements Extension {
    Logger logger;
    NotificationManager notificationManager;
    SessionManager sessionManager;
    SessionInfo sessionInfo;
    ExtensionConfig config;

    @Subscribe
    public void onCommandDefine(GeyserDefineCommandsEvent event) {
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("restart").description("Restart the connection to Xbox Live.").executor((source, command, args) -> {
            if (!source.isConsole()) {
                source.sendMessage("This command can only be ran from the console.");
                return;
            }
            this.restart();
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("dumpsession").description("Dump the current session to json files.").executor((source, command, args) -> {
            if (!source.isConsole()) {
                source.sendMessage("This command can only be ran from the console.");
                return;
            }
            this.logger.info("Dumping session responses to 'lastSessionResponse.json' and 'currentSessionResponse.json'");
            this.sessionManager.dumpSession();
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("accounts").description("Manage sub-accounts.").executor((source, command, args) -> {
            if (!source.isConsole()) {
                source.sendMessage("This command can only be ran from the console.");
                return;
            }
            if (args.length < 2) {
                if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
                    this.sessionManager.listSessions();
                    return;
                }
                source.sendMessage("Usage:");
                source.sendMessage("accounts list");
                source.sendMessage("accounts add/remove <sub-session-id>");
                return;
            }
            switch (args[0].toLowerCase()) {
                case "add": {
                    this.sessionManager.addSubSession(args[1]);
                    break;
                }
                case "remove": {
                    this.sessionManager.removeSubSession(args[1]);
                    break;
                }
                default: {
                    source.sendMessage("Unknown accounts command: " + args[0]);
                }
            }
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("version").description("Get the version of the extension.").executor((source, command, args) -> source.sendMessage("MCXboxBroadcast Extension build 112 (git-master-32f42da)")).build());
    }

    private void restart() {
        this.sessionManager.shutdown();
        this.sessionManager = new SessionManager(new FileStorageManager(this.dataFolder().toString(), this.dataFolder().resolve("screenshot.jpg").toString()), this.notificationManager, this.logger);
        this.sessionManager.scheduledThread().execute(this::createSession);
    }

    @Subscribe
    public void onPostInitialize(GeyserPostInitializeEvent event) {
        this.logger = new ExtensionLoggerImpl(this.logger());
        this.logger.info("Starting MCXboxBroadcast Extension build 112 (git-master-32f42da) for Bedrock " + Constants.BEDROCK_CODEC.getMinecraftVersion() + " (" + Constants.BEDROCK_CODEC.getProtocolVersion() + ")");
        this.config = ConfigLoader.load(this, MCXboxBroadcastExtension.class, ExtensionConfig.class);
        if (this.config == null) {
            this.logger.error("Failed to load config, extension will not start!");
            this.disable();
            return;
        }
        this.notificationManager = new SlackNotificationManager(this.logger, this.config.slackWebhook());
        this.sessionManager = new SessionManager(new FileStorageManager(this.dataFolder().toString(), this.dataFolder().resolve("screenshot.jpg").toString()), this.notificationManager, this.logger);
        this.sessionManager.scheduledThread().execute(() -> {
            String ip = this.config.remoteAddress();
            if (ip.equals("auto")) {
                ip = this.geyserApi().bedrockListener().address();
                try {
                    InetAddress address = InetAddress.getByName(ip);
                    if (address.isSiteLocalAddress() || address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                        HttpRequest ipRequest = HttpRequest.newBuilder().uri(URI.create("https://ipv4.icanhazip.com")).GET().build();
                        ip = HttpClient.newHttpClient().send(ipRequest, HttpResponse.BodyHandlers.ofString()).body().trim();
                    }
                }
                catch (IOException | InterruptedException address) {
                    // empty catch block
                }
            }
            int port = this.geyserApi().bedrockListener().port();
            if (!this.config.remotePort().equals("auto")) {
                port = Integer.parseInt(this.config.remotePort());
            }
            this.sessionInfo = new SessionInfo();
            this.sessionInfo.setHostName(this.geyserApi().bedrockListener().secondaryMotd());
            this.sessionInfo.setWorldName(this.geyserApi().bedrockListener().primaryMotd());
            this.sessionInfo.setPlayers(this.geyserApi().onlineConnections().size());
            this.sessionInfo.setMaxPlayers(GeyserImpl.getInstance().getConfig().getMaxPlayers());
            if (this.sessionInfo.getHostName().isEmpty()) {
                this.sessionInfo.setHostName(this.sessionManager.getGamertag());
            }
            this.sessionInfo.setIp(ip);
            this.sessionInfo.setPort(port);
            this.createSession();
        });
    }

    @Subscribe
    public void onShutdown(GeyserShutdownEvent event) {
        this.sessionManager.shutdown();
    }

    @Subscribe
    public void onBedrockPing(GeyserBedrockPingEvent event) {
        if (this.sessionInfo == null) {
            return;
        }
        this.sessionInfo.setHostName(event.secondaryMotd());
        this.sessionInfo.setWorldName(event.primaryMotd());
        this.sessionInfo.setPlayers(event.playerCount());
        this.sessionInfo.setMaxPlayers(event.maxPlayerCount());
        if (this.sessionInfo.getHostName().isEmpty()) {
            this.sessionInfo.setHostName(this.sessionManager.getGamertag());
        }
    }

    private void createSession() {
        this.sessionManager.restartCallback(this::restart);
        try {
            this.sessionManager.init(this.sessionInfo, this.config.friendSync());
        }
        catch (SessionCreationException | SessionUpdateException e) {
            this.sessionManager.logger().error("Failed to create xbox session!", e);
            return;
        }
        this.sessionManager.scheduledThread().scheduleWithFixedDelay(this::tick, this.config.updateInterval(), this.config.updateInterval(), TimeUnit.SECONDS);
    }

    private void tick() {
        try {
            this.sessionManager.updateSession(this.sessionInfo);
        }
        catch (SessionUpdateException e) {
            this.sessionManager.logger().error("Failed to update session information!", e);
        }
    }
}

