/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.models.auth.PlayfabLoginBody;
import com.rtm516.mcxboxbroadcast.core.models.auth.SisuAuthorizeBody;
import com.rtm516.mcxboxbroadcast.core.models.auth.XboxTokenInfo;
import com.rtm516.mcxboxbroadcast.core.models.auth.XstsAuthData;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;
import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.MinecraftAuth;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.PlayFabResponseHandler;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.XblResponseHandler;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.AbstractStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.StepCredentialsMsaCode;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.StepMsaDeviceCode;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.StepMsaToken;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.xbl.StepXblDeviceToken;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.xbl.StepXblSisuAuthentication;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.CryptUtil;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.JsonContent;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.JsonUtil;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.OAuthEnvironment;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.logging.ILogger;
import java.io.IOException;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;

public class AuthManager {
    private final NotificationManager notificationManager;
    private final StorageManager storageManager;
    private final Logger logger;
    private StepXblSisuAuthentication.XblSisuTokens xboxToken;
    private XboxTokenInfo xboxTokenInfo;
    private String playfabSessionTicket;
    private Runnable onDeviceTokenRefreshCallback;

    public AuthManager(NotificationManager notificationManager, StorageManager storageManager, Logger logger) {
        this.notificationManager = notificationManager;
        this.storageManager = storageManager;
        this.logger = logger.prefixed("Auth");
        this.xboxToken = null;
    }

    public static XstsAuthData fromCredentials(String email, String password, ILogger logger) throws Exception {
        AbstractStep.ApplicationDetails appDetails = new AbstractStep.ApplicationDetails("0000000048183522", "service::user.auth.xboxlive.com::MBI_SSL", null, OAuthEnvironment.LIVE.getNativeClientUrl(), OAuthEnvironment.LIVE);
        StepMsaToken initialAuth = new StepMsaToken(new StepCredentialsMsaCode(appDetails));
        StepInitialXblSession xblAuth = new StepInitialXblSession(initialAuth, new StepXblDeviceToken("Android"));
        StepXblSisuAuthentication xstsAuth = new StepXblSisuAuthentication(xblAuth, "http://xboxlive.com");
        HttpClient httpClient = MinecraftAuth.createHttpClient();
        return new XstsAuthData((StepXblSisuAuthentication.XblSisuTokens)xstsAuth.getFromInput(logger, httpClient, new StepCredentialsMsaCode.MsaCredentials(email, password)), xstsAuth);
    }

    private void initialise() {
        HttpClient httpClient = MinecraftAuth.createHttpClient();
        if (this.xboxToken == null) {
            try {
                String cacheData = this.storageManager.cache();
                if (!cacheData.isBlank()) {
                    this.xboxToken = MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.fromJson(JsonUtil.parseString(cacheData).getAsJsonObject());
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to load cache.json", e);
            }
        }
        try {
            String oldDeviceTokenId;
            String string = oldDeviceTokenId = this.xboxToken != null ? this.xboxToken.getInitialXblSession().getXblDeviceToken().getDeviceId() : null;
            if (this.xboxToken == null) {
                this.xboxToken = MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.getFromInput(this.logger, httpClient, new StepMsaDeviceCode.MsaDeviceCodeCallback(msaDeviceCode -> {
                    this.logger.info("To sign in, use a web browser to open the page " + msaDeviceCode.getVerificationUri() + " and enter the code " + msaDeviceCode.getUserCode() + " to authenticate.");
                    this.notificationManager.sendSessionExpiredNotification(msaDeviceCode.getVerificationUri(), msaDeviceCode.getUserCode());
                }));
            } else if (this.xboxToken.isExpired()) {
                this.xboxToken = MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.refresh(this.logger, httpClient, this.xboxToken);
            }
            this.storageManager.cache(Constants.GSON.toJson(MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.toJson(this.xboxToken)));
            this.xboxTokenInfo = new XboxTokenInfo(this.xboxToken);
            this.playfabSessionTicket = this.fetchPlayfabSessionTicket(httpClient);
            String newDeviceTokenId = this.xboxToken.getInitialXblSession().getXblDeviceToken().getDeviceId();
            if (oldDeviceTokenId != null && newDeviceTokenId != null && !newDeviceTokenId.equals(oldDeviceTokenId)) {
                this.logger.debug("Device token has changed");
                if (this.onDeviceTokenRefreshCallback != null) {
                    this.onDeviceTokenRefreshCallback.run();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get/refresh auth token", e);
        }
    }

    private String fetchPlayfabSessionTicket(HttpClient httpClient) throws IOException {
        StepInitialXblSession.InitialXblSession initialSession = this.xboxToken.getInitialXblSession();
        HttpContentRequest authorizeRequest = new PostRequest("https://sisu.xboxlive.com/authorize").setContent(new JsonContent(SisuAuthorizeBody.create(initialSession, "https://b980a380.minecraft.playfabapi.com/")));
        authorizeRequest.setHeader(CryptUtil.getSignatureHeader(authorizeRequest, initialSession.getXblDeviceToken().getPrivateKey()));
        JsonObject authorizeResponse = httpClient.execute(authorizeRequest, new XblResponseHandler());
        StepXblXstsToken.XblXstsToken tokens = StepXblXstsToken.XblXstsToken.fromMicrosoftJson(authorizeResponse.getAsJsonObject("AuthorizationToken"), null);
        HttpContentRequest playfabRequest = new PostRequest("https://20ca2.playfabapi.com/Client/LoginWithXbox").setContent(new JsonContent(PlayfabLoginBody.create(tokens.getServiceToken())));
        JsonObject playfabResponse = httpClient.execute(playfabRequest, new PlayFabResponseHandler());
        return playfabResponse.getAsJsonObject("data").get("SessionTicket").getAsString();
    }

    public XboxTokenInfo getXboxToken() {
        if (this.xboxToken == null || this.xboxTokenInfo == null || this.xboxToken.isExpired()) {
            this.logger.debug("xboxToken Need Refresh. (xboxToken: " + (this.xboxToken != null) + ", xboxTokenInfo: " + (this.xboxTokenInfo != null) + ", xboxToken.isExpired: " + (this.xboxToken != null && this.xboxToken.isExpired()) + ")");
            this.initialise();
        }
        return this.xboxTokenInfo;
    }

    public String getPlayfabSessionTicket() {
        if (this.playfabSessionTicket == null) {
            this.logger.debug("Playfab Session Ticket Need Refresh. (playfabSessionTicket is null)");
            this.initialise();
        }
        return this.playfabSessionTicket;
    }

    public void updateGamertag(String gamertag) {
        try {
            JsonObject xboxTokenJson = MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.toJson(this.xboxToken);
            xboxTokenJson.getAsJsonObject("xstsToken").getAsJsonObject("displayClaims").addProperty("gtg", gamertag);
            this.xboxToken = MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.fromJson(xboxTokenJson);
            this.storageManager.cache(Constants.GSON.toJson(MinecraftAuth.BEDROCK_XBL_DEVICE_CODE_LOGIN.toJson(this.xboxToken)));
            this.xboxTokenInfo = new XboxTokenInfo(this.xboxToken);
        }
        catch (Exception e) {
            this.logger.error("Failed to update gamertag", e);
        }
    }

    public void setOnDeviceTokenRefreshCallback(Runnable onDeviceTokenRefreshCallback) {
        this.onDeviceTokenRefreshCallback = onDeviceTokenRefreshCallback;
    }
}

