/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonDeserializationContext;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonDeserializer;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonElement;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonParseException;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonPrimitive;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonSerializationContext;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateConverter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS").withZone(ZoneOffset.UTC);

    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            Object dateString = json.getAsString();
            if (((String)dateString).endsWith("Z")) {
                dateString = ((String)dateString).substring(0, ((String)dateString).length() - 1);
            }
            if (((String)dateString).contains(".")) {
                int fractionalDigits = ((String)dateString).length() - ((String)dateString).indexOf(46) - 1;
                if (fractionalDigits < 7) {
                    dateString = (String)dateString + "0".repeat(7 - fractionalDigits);
                }
            } else if (!((String)dateString).isBlank()) {
                dateString = (String)dateString + ".0000000";
            }
            Instant instant = dateFormat.parse((CharSequence)dateString, Instant::from);
            return Date.from(instant);
        }
        catch (Exception e) {
            throw new JsonParseException(e);
        }
    }

    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(dateFormat.format(src.toInstant()));
    }
}

