/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.configs.FriendSyncConfig;
import com.rtm516.mcxboxbroadcast.core.exceptions.XboxFriendsException;
import com.rtm516.mcxboxbroadcast.core.models.friend.FriendModifyResponse;
import com.rtm516.mcxboxbroadcast.core.models.friend.FriendRequestAcceptResponse;
import com.rtm516.mcxboxbroadcast.core.models.friend.FriendRequestResponse;
import com.rtm516.mcxboxbroadcast.core.models.friend.FriendStatusResponse;
import com.rtm516.mcxboxbroadcast.core.models.session.CreateHandleRequest;
import com.rtm516.mcxboxbroadcast.core.models.session.FollowerResponse;
import com.rtm516.mcxboxbroadcast.core.models.session.SessionRef;
import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FriendManager {
    private final HttpClient httpClient;
    private final Logger logger;
    private final SessionManagerCore sessionManager;
    private final Map<String, String> toAdd;
    private final Map<String, String> toRemove;
    private List<FollowerResponse.Person> lastFriendCache;
    private Future<?> internalScheduledFuture;
    private boolean initialInvite;

    public FriendManager(HttpClient httpClient, Logger logger, SessionManagerCore sessionManager) {
        this.httpClient = httpClient;
        this.logger = logger;
        this.sessionManager = sessionManager;
        this.toAdd = new HashMap<String, String>();
        this.toRemove = new HashMap<String, String>();
    }

    public List<FollowerResponse.Person> get() throws XboxFriendsException {
        ArrayList<FollowerResponse.Person> people = new ArrayList<FollowerResponse.Person>();
        HttpRequest xboxFollowersRequest = HttpRequest.newBuilder().uri(Constants.FOLLOWERS).header("Authorization", this.sessionManager.getTokenHeader()).header("x-xbl-contract-version", "5").header("accept-language", "en-GB").GET().build();
        String lastResponse = "";
        try {
            lastResponse = this.httpClient.send(xboxFollowersRequest, HttpResponse.BodyHandlers.ofString()).body();
            if (!lastResponse.isEmpty()) {
                FollowerResponse xboxFollowerResponse = Constants.GSON.fromJson(lastResponse, FollowerResponse.class);
                if (xboxFollowerResponse.people != null) {
                    people.addAll(xboxFollowerResponse.people);
                }
            }
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            this.logger.debug("Follower request response: " + lastResponse);
            throw new XboxFriendsException(e.getMessage());
        }
        HttpRequest xboxSocialRequest = HttpRequest.newBuilder().uri(Constants.SOCIAL).header("Authorization", this.sessionManager.getTokenHeader()).header("x-xbl-contract-version", "5").header("accept-language", "en-GB").GET().build();
        try {
            lastResponse = this.httpClient.send(xboxSocialRequest, HttpResponse.BodyHandlers.ofString()).body();
            if (!lastResponse.isEmpty()) {
                FollowerResponse xboxSocialResponse = Constants.GSON.fromJson(lastResponse, FollowerResponse.class);
                if (xboxSocialResponse.people != null) {
                    people.addAll(xboxSocialResponse.people);
                }
            }
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            this.logger.debug("Social request response: " + lastResponse);
            throw new XboxFriendsException(e.getMessage());
        }
        HashMap<String, FollowerResponse.Person> outPeople = new HashMap<String, FollowerResponse.Person>();
        for (FollowerResponse.Person person : people) {
            if (outPeople.containsKey(person.xuid)) {
                outPeople.put(person.xuid, ((FollowerResponse.Person)outPeople.get(person.xuid)).merge(person));
                continue;
            }
            outPeople.put(person.xuid, person);
        }
        ArrayList<FollowerResponse.Person> outPeopleList = new ArrayList<FollowerResponse.Person>(outPeople.values());
        this.lastFriendCache = outPeopleList;
        return outPeopleList;
    }

    public void add(String xuid, String gamertag) {
        this.toRemove.remove(xuid);
        this.toAdd.put(xuid, gamertag);
        this.callInternalProcess();
    }

    public boolean addIfRequired(String xuid, String gamertag) {
        if (this.toAdd.containsKey(xuid)) {
            return false;
        }
        HttpRequest xboxFriendStatus = HttpRequest.newBuilder().uri(URI.create("https://social.xboxlive.com/users/me/people/xuid(%s)".formatted(xuid))).header("Authorization", this.sessionManager.getTokenHeader()).GET().build();
        try {
            HttpResponse<String> response = this.httpClient.send(xboxFriendStatus, HttpResponse.BodyHandlers.ofString());
            FriendStatusResponse modifyResponse = Constants.GSON.fromJson(response.body(), FriendStatusResponse.class);
            if (modifyResponse.isFollowingCaller() && modifyResponse.isFollowedByCaller()) {
                return false;
            }
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            this.logger.debug("Failed to check if " + gamertag + " (" + xuid + ") is a friend: " + e.getMessage());
        }
        this.add(xuid, gamertag);
        return true;
    }

    public void remove(String xuid, String gamertag) {
        this.toAdd.remove(xuid);
        this.toRemove.put(xuid, gamertag);
        this.callInternalProcess();
    }

    public void init(FriendSyncConfig friendSyncConfig) {
        this.initAutoFriend(friendSyncConfig);
        if (!friendSyncConfig.shouldExpire()) {
            return;
        }
        StorageManager.PlayerHistoryStorage playerHistory = this.sessionManager.storageManager().playerHistory();
        if (playerHistory.isFirstRun()) {
            this.logger.info("Player history is being initialized for the first time, this may take a few seconds");
            try {
                for (FollowerResponse.Person friend : this.sessionManager.friendManager().get()) {
                    playerHistory.lastSeen(friend.xuid, Instant.now());
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to initialize player history", e);
            }
        }
        this.sessionManager.scheduledThread().scheduleWithFixedDelay(() -> {
            try {
                HashMap xuidGamertagMap = new HashMap();
                this.lastFriendCache().forEach(person -> xuidGamertagMap.put(person.xuid, person.gamertag));
                for (Map.Entry<String, Instant> entry : playerHistory.all().entrySet()) {
                    String xuid = entry.getKey();
                    Instant lastSeen = entry.getValue();
                    if (!lastSeen.isBefore(Instant.now().minusSeconds(friendSyncConfig.expireDays() * 24 * 3600))) continue;
                    try {
                        this.logger.info("Removing player " + xuid + " from friends due to inactivity");
                        this.forceUnfollow(xuid);
                    }
                    catch (Exception e) {
                        if (e.getMessage().startsWith("429: ")) {
                            this.logger.warn("Rate limited while trying to remove player " + xuid + " from friends for inactivity, will try again later");
                            return;
                        }
                        this.logger.error("Failed to remove player " + xuid + " from friends for inactivity", e);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to clean up friends list", e);
            }
        }, 10L, friendSyncConfig.expireCheck(), TimeUnit.SECONDS);
    }

    private void initAutoFriend(FriendSyncConfig friendSyncConfig) {
        this.initialInvite = friendSyncConfig.initialInvite();
        if (friendSyncConfig.autoFollow() || friendSyncConfig.autoUnfollow()) {
            this.sessionManager.scheduledThread().scheduleWithFixedDelay(() -> {
                try {
                    for (FollowerResponse.Person person : this.get()) {
                        if (this.isGuestAccount(person.xuid)) continue;
                        if (friendSyncConfig.autoFollow() && person.isFollowingCaller && !person.isFollowedByCaller) {
                            this.add(person.xuid, person.displayName);
                        }
                        if (!friendSyncConfig.autoUnfollow() || person.isFollowingCaller || !person.isFollowedByCaller) continue;
                        this.remove(person.xuid, person.displayName);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to sync friends", e);
                }
            }, friendSyncConfig.updateInterval(), friendSyncConfig.updateInterval(), TimeUnit.SECONDS);
        }
    }

    private boolean isGuestAccount(long xuid) {
        return xuid >> 52 == 1L;
    }

    private boolean isGuestAccount(String xuid) {
        try {
            return this.isGuestAccount(Long.parseLong(xuid));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void callInternalProcess() {
        if (this.internalScheduledFuture != null && !this.internalScheduledFuture.isDone()) {
            return;
        }
        this.internalScheduledFuture = this.sessionManager.scheduledThread().submit(this::internalProcess);
    }

    private void internalProcess() {
        Optional<String> header;
        Optional<FollowerResponse.Person> friend;
        HttpResponse<String> response;
        HttpRequest xboxFriendRequest;
        HashMap<String, String> toProcess;
        int retryAfter = 0;
        if (this.lastFriendCache == null) {
            this.lastFriendCache = new ArrayList<FollowerResponse.Person>();
        }
        if (!this.toAdd.isEmpty()) {
            toProcess = new HashMap<String, String>(this.toAdd);
            for (Map.Entry entry : toProcess.entrySet()) {
                xboxFriendRequest = HttpRequest.newBuilder().uri(URI.create("https://social.xboxlive.com/users/me/people/xuid(%s)".formatted(entry.getKey()))).header("Authorization", this.sessionManager.getTokenHeader()).PUT(HttpRequest.BodyPublishers.noBody()).build();
                try {
                    FriendModifyResponse modifyResponse;
                    response = this.httpClient.send(xboxFriendRequest, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 204) {
                        this.toAdd.remove(entry.getKey());
                        this.logger.info("Added " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend");
                        this.sendInvite((String)entry.getKey());
                        friend = this.lastFriendCache.stream().filter(p -> p.xuid.equals(entry.getKey())).findFirst();
                        friend.ifPresent(person -> {
                            person.isFollowedByCaller = true;
                        });
                        continue;
                    }
                    if (response.statusCode() == 429) {
                        header = response.headers().firstValue("Retry-After");
                        if (header.isPresent()) {
                            retryAfter = Integer.parseInt(header.get());
                        }
                        this.logger.debug("Failed to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: (" + response.statusCode() + ") " + response.body());
                        break;
                    }
                    if (response.statusCode() == 400) {
                        modifyResponse = Constants.GSON.fromJson(response.body(), FriendModifyResponse.class);
                        if (modifyResponse.code() == 1028) {
                            this.logger.error("Friend list full, unable to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend");
                            break;
                        }
                        this.logger.warn("Failed to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: (" + response.statusCode() + ") " + response.body());
                        continue;
                    }
                    modifyResponse = Constants.GSON.fromJson(response.body(), FriendModifyResponse.class);
                    if (modifyResponse.code() == 1028) {
                        this.logger.error("Friend list full, unable to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend");
                        continue;
                    }
                    if (modifyResponse.code() == 1011 || modifyResponse.code() == 1049) {
                        this.toAdd.remove(entry.getKey());
                        try {
                            this.forceUnfollow((String)entry.getKey());
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to force unfollow user", e);
                        }
                        this.logger.warn("Removed " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend due to restrictions on their account");
                        this.sessionManager.notificationManager().sendFriendRestrictionNotification((String)entry.getValue(), (String)entry.getKey());
                        continue;
                    }
                    this.logger.warn("Failed to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: (" + response.statusCode() + ") " + response.body());
                }
                catch (IOException | InterruptedException e) {
                    this.logger.error("Failed to add " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: " + e.getMessage());
                    break;
                }
            }
        }
        if (!this.toRemove.isEmpty()) {
            toProcess = new HashMap<String, String>(this.toRemove);
            for (Map.Entry entry : toProcess.entrySet()) {
                xboxFriendRequest = HttpRequest.newBuilder().uri(URI.create("https://social.xboxlive.com/users/me/people/xuid(%s)".formatted(entry.getKey()))).header("Authorization", this.sessionManager.getTokenHeader()).DELETE().build();
                try {
                    response = this.httpClient.send(xboxFriendRequest, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() == 204) {
                        this.toRemove.remove(entry.getKey());
                        this.logger.info("Removed " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend");
                        this.sessionManager.storageManager().playerHistory().clear((String)entry.getKey());
                        friend = this.lastFriendCache.stream().filter(p -> p.xuid.equals(entry.getKey())).findFirst();
                        friend.ifPresent(person -> {
                            person.isFollowedByCaller = false;
                        });
                        continue;
                    }
                    if (response.statusCode() == 429) {
                        header = response.headers().firstValue("Retry-After");
                        if (header.isPresent()) {
                            retryAfter = Integer.parseInt(header.get());
                        }
                        this.logger.debug("Failed to remove " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: (" + response.statusCode() + ") " + response.body());
                        break;
                    }
                    this.logger.warn("Failed to remove " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: (" + response.statusCode() + ") " + response.body());
                }
                catch (IOException | InterruptedException e) {
                    this.logger.error("Failed to remove " + (String)entry.getValue() + " (" + (String)entry.getKey() + ") as a friend: " + e.getMessage());
                    break;
                }
            }
        }
        if (!this.toAdd.isEmpty() || !this.toRemove.isEmpty()) {
            this.internalScheduledFuture = this.sessionManager.scheduledThread().schedule(this::internalProcess, (long)retryAfter, TimeUnit.SECONDS);
        }
    }

    public void forceUnfollow(String xuid) throws Exception {
        HttpRequest followerDeleteRequest = HttpRequest.newBuilder().uri(URI.create("https://social.xboxlive.com/users/me/people/follower/xuid(%s)".formatted(xuid))).header("Authorization", this.sessionManager.getTokenHeader()).DELETE().build();
        HttpResponse<String> response = this.httpClient.send(followerDeleteRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 204) {
            throw new RuntimeException(response.statusCode() + ": " + response.body());
        }
        this.lastFriendCache.removeIf(person -> person.xuid.equals(xuid));
        this.sessionManager.storageManager().playerHistory().clear(xuid);
    }

    public List<FollowerResponse.Person> lastFriendCache() {
        if (this.lastFriendCache == null) {
            try {
                this.lastFriendCache = this.get();
            }
            catch (XboxFriendsException e) {
                this.logger.error("Failed to get friends from Xbox Live", e);
                this.lastFriendCache = new ArrayList<FollowerResponse.Person>();
            }
        }
        return this.lastFriendCache;
    }

    public void acceptPendingFriendRequests() {
        try {
            HttpRequest friendRequests = HttpRequest.newBuilder().uri(URI.create("https://peoplehub.xboxlive.com/users/me/people/friendrequests(received)")).header("Authorization", this.sessionManager.getTokenHeader()).header("x-xbl-contract-version", "7").header("accept-language", "en-GB").GET().build();
            HttpResponse<String> response = this.httpClient.send(friendRequests, HttpResponse.BodyHandlers.ofString());
            FriendRequestResponse friendRequestResponse = Constants.GSON.fromJson(response.body(), FriendRequestResponse.class);
            List xuids = friendRequestResponse.people.stream().map(person -> person.xuid).collect(Collectors.toUnmodifiableList());
            if (xuids.isEmpty()) {
                return;
            }
            HttpRequest acceptRequests = HttpRequest.newBuilder().uri(URI.create("https://social.xboxlive.com/bulk/users/me/people/friends/v2?method=add")).header("Authorization", this.sessionManager.getTokenHeader()).POST(HttpRequest.BodyPublishers.ofString(Constants.GSON.toJson(Map.of("xuids", xuids)))).build();
            HttpResponse<String> acceptResponse = this.httpClient.send(acceptRequests, HttpResponse.BodyHandlers.ofString());
            FriendRequestAcceptResponse friendRequestAcceptResponse = Constants.GSON.fromJson(acceptResponse.body(), FriendRequestAcceptResponse.class);
            for (String xuid : friendRequestAcceptResponse.updatedPeople) {
                Optional<FollowerResponse.Person> friend = friendRequestResponse.people.stream().filter(p -> p.xuid.equals(xuid)).findFirst();
                if (friend.isEmpty()) continue;
                this.logger.info("Added " + friend.get().gamertag + " (" + xuid + ") as a friend");
                this.sendInvite(xuid);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Failed to accept friend requests", e);
        }
    }

    public void sendInvite(String xuid) {
        if (!this.initialInvite) {
            return;
        }
        try {
            CreateHandleRequest createHandleContent = new CreateHandleRequest(1, "invite", new SessionRef("4fc10100-5f7a-4470-899b-280835760c07", "MinecraftLobby", this.sessionManager.getSessionId()), xuid, Map.of("titleId", "896928775"));
            HttpRequest sendInvite = HttpRequest.newBuilder().uri(Constants.CREATE_HANDLE).header("Authorization", this.sessionManager.getTokenHeader()).header("x-xbl-contract-version", "107").POST(HttpRequest.BodyPublishers.ofString(Constants.GSON.toJson(createHandleContent))).build();
            HttpResponse<String> inviteResponse = this.httpClient.send(sendInvite, HttpResponse.BodyHandlers.ofString());
            this.logger.debug(inviteResponse.body());
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Failed to send invite to " + xuid + ": " + e.getMessage());
        }
    }
}

