/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.models.ws.MessageType;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class RtaWebsocketClient
extends WebSocketClient {
    private final SessionManagerCore sessionManager;
    private String connectionId;
    private final Logger logger;
    private final String xuid;
    private boolean isFirstConnection = true;
    private CompletableFuture<String> connectionIdFuture = new CompletableFuture();

    public RtaWebsocketClient(SessionManagerCore sessionManager) {
        super(Constants.RTA_WEBSOCKET);
        this.addHeader("Authorization", sessionManager.getTokenHeader());
        this.sessionManager = sessionManager;
        this.xuid = sessionManager.userXUID();
        this.logger = sessionManager.logger();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public CompletableFuture<String> getConnectionIdFuture() {
        return this.connectionIdFuture;
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        this.send("[1,1,\"https://sessiondirectory.xboxlive.com/connections/\"]");
    }

    @Override
    public void onMessage(String message) {
        Object[] parts = Constants.GSON.fromJson(message, Object[].class);
        MessageType type = MessageType.fromValue(((Double)parts[0]).intValue());
        switch (type) {
            case Subscribe: {
                this.logger.debug("RTA Websocket [" + this.connectionId + "] subscribed: " + message);
                if (!message.contains("ConnectionId") || !this.isFirstConnection) break;
                this.connectionId = (String)((Map)parts[4]).get("ConnectionId");
                this.connectionIdFuture.complete(this.connectionId);
                this.isFirstConnection = false;
                this.send("[1,2,\"https://social.xboxlive.com/users/xuid(" + this.xuid + ")/friends\"]");
                break;
            }
            case Unsubscribe: {
                this.logger.debug("RTA Websocket [" + this.connectionId + "] unsubscribed: " + message);
                break;
            }
            case Event: {
                this.logger.debug("RTA Websocket [" + this.connectionId + "] event: " + message);
                Map data = (Map)parts[2];
                if (!data.getOrDefault("NotificationType", "").equals("IncomingFriendRequestCountChanged")) break;
                this.logger.debug("RTA Websocket [" + this.connectionId + "] friend request: " + message);
                this.sessionManager.friendManager().acceptPendingFriendRequests();
                break;
            }
            case Resync: {
                this.logger.debug("RTA Websocket [" + this.connectionId + "] resync: " + message);
                break;
            }
            default: {
                this.logger.debug("RTA Websocket [" + this.connectionId + "] unknown: " + message);
            }
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        if (!this.connectionIdFuture.isDone()) {
            this.connectionIdFuture.completeExceptionally(new Exception("RTA Websocket [" + this.connectionId + "] disconnected before connectionId was received"));
        }
        String reasonString = reason.isEmpty() && code == 1000 ? "Normal close" : reason;
        this.logger.debug("RTA Websocket [" + this.connectionId + "] disconnected: " + reasonString + " (" + code + ")");
    }

    @Override
    public void onError(Exception ex) {
        this.logger.error("RTA Websocket [" + this.connectionId + "] error: " + ex.getMessage(), ex);
    }
}

