/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import com.rtm516.mcxboxbroadcast.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SessionInfo {
    @JsonIgnore
    private static final Pattern COLOR_PATTERN = Pattern.compile("\u00a7[\\w]");
    @JsonProperty(value="host-name")
    private String hostName;
    @JsonProperty(value="world-name")
    private String worldName;
    private int players;
    @JsonProperty(value="max-players")
    private int maxPlayers;
    private String ip;
    private int port;

    public SessionInfo() {
    }

    public SessionInfo(String hostName, String worldName, int players, int maxPlayers, String ip, int port) {
        this.hostName = hostName;
        this.worldName = worldName;
        this.players = players;
        this.maxPlayers = maxPlayers;
        this.ip = ip;
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = SessionInfo.removeColorCodes(hostName);
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = SessionInfo.removeColorCodes(worldName);
    }

    public String getVersion() {
        return Constants.BEDROCK_CODEC.getMinecraftVersion();
    }

    public int getProtocol() {
        return Constants.BEDROCK_CODEC.getProtocolVersion();
    }

    public int getPlayers() {
        if (this.players <= 0) {
            return 1;
        }
        return this.players;
    }

    public void setPlayers(int players) {
        this.players = players;
    }

    public int getMaxPlayers() {
        if (this.maxPlayers <= this.getPlayers()) {
            return this.getPlayers() + 1;
        }
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SessionInfo copy() {
        return new SessionInfo(this.hostName, this.worldName, this.players, this.maxPlayers, this.ip, this.port);
    }

    private static String removeColorCodes(String string) {
        Matcher matcher = COLOR_PATTERN.matcher(string);
        return matcher.replaceAll("");
    }
}

