/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionManager;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionUpdateException;
import com.rtm516.mcxboxbroadcast.core.models.session.JoinSessionRequest;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;
import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import java.util.concurrent.ScheduledExecutorService;

public class SubSessionManager
extends SessionManagerCore {
    private final SessionManager parent;

    public SubSessionManager(String id, SessionManager parent, StorageManager storageManager, NotificationManager notificationManager, Logger logger) {
        super(storageManager, notificationManager, logger.prefixed("Sub-Session " + id));
        this.parent = parent;
    }

    @Override
    public ScheduledExecutorService scheduledThread() {
        return this.parent.scheduledThread();
    }

    @Override
    public String getSessionId() {
        return this.parent.sessionInfo().getSessionId();
    }

    @Override
    protected boolean handleFriendship() {
        boolean subAdd = this.friendManager().addIfRequired(this.parent.getXboxToken().userXUID(), this.parent.getXboxToken().gamertag());
        boolean mainAdd = this.parent.friendManager().addIfRequired(this.getXboxToken().userXUID(), this.getXboxToken().gamertag());
        return subAdd || mainAdd;
    }

    @Override
    protected void updateSession() throws SessionUpdateException {
        super.updateSessionInternal("https://sessiondirectory.xboxlive.com/handles/%s/session".formatted(this.parent.sessionInfo().getHandleId()), new JoinSessionRequest(this.parent.sessionInfo()));
    }
}

