/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x500.X500Name;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.digests.SHA256Digest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.ContentSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.OperatorCreationException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.CertificateRequest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DefaultTlsClient;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsAuthentication;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentials;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsServerCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class DtlsClient
extends DefaultTlsClient {
    private final JcaTlsCrypto crypto;
    private final String finalFingerprint;
    private final Logger logger;
    private final KeyPair keyPair;
    private final X509Certificate cert;
    private final Certificate bcCert;

    public DtlsClient(JcaTlsCrypto crypto, String serverFingerprint, Logger logger) throws NoSuchAlgorithmException, CertificateException, OperatorCreationException {
        super(crypto);
        this.crypto = crypto;
        this.finalFingerprint = serverFingerprint;
        this.logger = logger.prefixed("DtlsClient");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        this.keyPair = keyPairGenerator.generateKeyPair();
        X500Name subject = new X500Name("CN=Test Certificate");
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(subject, BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis() - 10000L), new Date(System.currentTimeMillis() + 31536000000L), subject, this.keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").setProvider("BC").build(this.keyPair.getPrivate());
        this.cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(contentSigner));
        this.bcCert = new Certificate(new TlsCertificate[]{new JcaTlsCertificate(crypto, this.cert)});
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                if (serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty()) {
                    DtlsClient.this.logger.error("Invalid certificate: " + String.valueOf(serverCertificate));
                    throw new TlsFatalAlert(42);
                }
                byte[] cert = serverCertificate.getCertificate().getCertificateAt(0).getEncoded();
                String fp = DtlsClient.this.fingerprintFor(cert);
                if (!fp.equals(DtlsClient.this.finalFingerprint)) {
                    DtlsClient.this.logger.error("Fingerprint does not match! Expected " + DtlsClient.this.finalFingerprint + " got " + fp);
                    throw new TlsFatalAlert(42);
                }
            }

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) {
                return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(DtlsClient.this.context), DtlsClient.this.crypto, DtlsClient.this.keyPair.getPrivate(), DtlsClient.this.bcCert, SignatureAndHashAlgorithm.rsa_pss_rsae_sha256);
            }
        };
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return new ProtocolVersion[]{ProtocolVersion.DTLSv12};
    }

    private String fingerprintFor(byte[] input) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(input, 0, input.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        byte[] hexBytes = Hex.encode(result);
        String hex = new String(hexBytes, StandardCharsets.US_ASCII).toUpperCase();
        StringBuilder fp = new StringBuilder();
        int i = 0;
        fp.append(hex, i, i + 2);
        while ((i += 2) < hex.length()) {
            fp.append(':');
            fp.append(hex, i, i + 2);
        }
        return fp.toString();
    }

    public String getClientFingerprint() throws CertificateEncodingException {
        return this.fingerprintFor(this.cert.getEncoded());
    }
}

