/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.webrtc.Utils;
import com.rtm516.mcxboxbroadcast.core.webrtc.bedrock.RedirectPacketHandler;
import com.rtm516.mcxboxbroadcast.core.webrtc.compression.CompressionHandler;
import com.rtm516.mcxboxbroadcast.core.webrtc.encryption.BedrockEncryptionEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.crypto.SecretKey;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec;
import org.cloudburstmc.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v3;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.cloudburstmc.protocol.common.util.VarInts;
import pe.pi.sctp4j.sctp.SCTPByteStreamListener;
import pe.pi.sctp4j.sctp.SCTPStream;

public class MinecraftDataHandler
implements SCTPByteStreamListener {
    private final BedrockPacketCodec packetCodec = new BedrockPacketCodec_v3();
    private final SCTPStream sctpStream;
    private final BedrockCodec codec;
    private final BedrockCodecHelper helper;
    private final RedirectPacketHandler redirectPacketHandler;
    private final Logger logger;
    private final SessionManagerCore sessionManager;
    private CompressionHandler compressionHandler;
    private BedrockEncryptionEncoder encryptionEncoder;
    private ByteBuf concat;
    private int expectedLength;

    public MinecraftDataHandler(SCTPStream sctpStream, BedrockCodec codec, SessionInfo sessionInfo, Logger logger, SessionManagerCore sessionManager) {
        this.sctpStream = sctpStream;
        this.codec = codec;
        this.helper = codec.createHelper();
        this.logger = logger.prefixed("MinecraftDataHandler");
        this.sessionManager = sessionManager;
        this.redirectPacketHandler = new RedirectPacketHandler(this, sessionInfo);
    }

    @Override
    public void onMessage(SCTPStream sctpStream, byte[] bytes) {
        try {
            if (bytes.length == 0) {
                throw new IllegalStateException("Expected at least 2 bytes");
            }
            ByteBuf buf = Unpooled.buffer(bytes.length);
            buf.writeBytes(bytes);
            byte remainingSegments = buf.readByte();
            if (remainingSegments > 0) {
                if (this.concat == null) {
                    this.concat = buf;
                } else {
                    this.concat.writeBytes(buf);
                }
                return;
            }
            if (this.concat != null) {
                this.concat.writeBytes(buf);
                buf = this.concat;
                this.concat = null;
            }
            if (this.compressionHandler != null) {
                buf = this.compressionHandler.decode(buf);
            }
            this.expectedLength = VarInts.readUnsignedInt(buf);
            BedrockPacket packet = this.readPacket(buf);
            if (!(packet instanceof LoginPacket)) {
                this.logger.debug("C -> S: " + String.valueOf(packet));
            } else {
                this.logger.debug("C -> S: LoginPacket");
            }
            packet.handle(this.redirectPacketHandler);
        }
        catch (Exception e) {
            this.logger.error("Failed to handle packet from NetherNet", e);
        }
    }

    @Override
    public void onMessage(SCTPStream sctpStream, String s2) {
    }

    @Override
    public void close(SCTPStream sctpStream) {
    }

    public void sendPacket(BedrockPacket packet) {
        this.logger.debug("S -> C: " + String.valueOf(packet));
        try {
            ByteBuf dataBuf = Unpooled.buffer(128);
            int shiftedBytes = 5;
            dataBuf.writerIndex(shiftedBytes);
            int packetId = this.codec.getPacketDefinition(packet.getClass()).getId();
            this.packetCodec.encodeHeader(dataBuf, BedrockPacketWrapper.create(packetId, 0, 0, null, null));
            this.codec.tryEncode(this.helper, dataBuf, packet);
            int lastPacketByte = dataBuf.writerIndex();
            dataBuf.readerIndex(shiftedBytes);
            int packetLength = lastPacketByte - shiftedBytes;
            dataBuf.readerIndex(5 - Utils.varintSize(packetLength));
            dataBuf.writerIndex(dataBuf.readerIndex());
            VarInts.writeUnsignedInt(dataBuf, packetLength);
            dataBuf.writerIndex(lastPacketByte);
            if (this.compressionHandler != null) {
                dataBuf = this.compressionHandler.encode(dataBuf);
            }
            int ri = dataBuf.readerIndex();
            dataBuf.readerIndex(ri);
            if (this.encryptionEncoder != null) {
                dataBuf = this.encryptionEncoder.encode(dataBuf);
                ri = dataBuf.readerIndex();
                dataBuf.readerIndex(ri);
            }
            int segmentCount = (int)Math.ceil((float)dataBuf.readableBytes() / 10000.0f);
            for (int remainingSegements = segmentCount - 1; remainingSegements >= 0; --remainingSegements) {
                int segmentLength = remainingSegements == 0 ? dataBuf.readableBytes() : 10000;
                ByteBuf sendBuf = Unpooled.buffer(segmentLength + 1 + 5);
                sendBuf.writeByte(remainingSegements);
                sendBuf.writeBytes(dataBuf, segmentLength);
                byte[] data = this.encode(sendBuf);
                this.sctpStream.send(data);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to send packet to NetherNet", e);
        }
    }

    private byte[] encode(ByteBuf buf) {
        byte[] send = new byte[buf.readableBytes()];
        buf.readBytes(send);
        return send;
    }

    private BedrockPacket readPacket(ByteBuf buf) {
        BedrockPacketWrapper wrapper = BedrockPacketWrapper.create();
        this.packetCodec.decodeHeader(buf, wrapper);
        BedrockPacket packet = this.codec.tryDecode(this.helper, buf.slice(), wrapper.getPacketId());
        wrapper.getHandle().recycle(wrapper);
        return packet;
    }

    public void enableCompression(PacketCompressionAlgorithm compressionAlgorithm, int threshold) {
        this.compressionHandler = new CompressionHandler(compressionAlgorithm, threshold);
    }

    public void enableEncryption(SecretKey secretKey) {
        this.encryptionEncoder = new BedrockEncryptionEncoder(secretKey, EncryptionUtils.createCipher(true, true, secretKey));
    }

    public SessionManagerCore sessionManager() {
        return this.sessionManager;
    }
}

