/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.models.ws.WsToMessage;
import com.rtm516.mcxboxbroadcast.core.webrtc.CustomDatagramTransport;
import com.rtm516.mcxboxbroadcast.core.webrtc.DtlsClient;
import com.rtm516.mcxboxbroadcast.core.webrtc.IceLogger;
import com.rtm516.mcxboxbroadcast.core.webrtc.RtcWebsocketClient;
import com.rtm516.mcxboxbroadcast.core.webrtc.SctpAssociationListener;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSClientProtocol;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSTransport;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramTransport;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SessionDescription;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.KeepAliveStrategy;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.opentelecoms.javax.sdp.NistSdpFactory;
import pe.pi.sctp4j.sctp.AssociationListener;
import pe.pi.sctp4j.sctp.small.CachedThreadedAssociation;

public class PeerSession {
    private final RtcWebsocketClient rtcWebsocket;
    private final SessionManagerCore sessionManager;
    private final Agent agent;
    private Component component;
    private DTLSTransport dtlsTransport;
    private String sessionId;
    private CachedThreadedAssociation threadedAssociation;
    private boolean hadFirstCandidate = false;
    private long lastCandidateTime = 0L;

    public PeerSession(RtcWebsocketClient rtcWebsocket, List<CandidateHarvester> candidateHarvesters, SessionManagerCore sessionManager) {
        this.rtcWebsocket = rtcWebsocket;
        this.sessionManager = sessionManager;
        this.agent = new Agent(new IceLogger(rtcWebsocket.logger()));
        for (CandidateHarvester harvester : candidateHarvesters) {
            this.agent.addCandidateHarvester(harvester);
        }
    }

    public void receiveOffer(BigInteger from, String sessionId, String message) {
        this.sessionId = sessionId;
        try {
            NistSdpFactory factory = new NistSdpFactory();
            SessionDescription offer = factory.createSessionDescription(message);
            IceMediaStream stream = this.agent.createMediaStream("application");
            String fingerprint = null;
            for (Object mediaDescription : offer.getMediaDescriptions(false)) {
                MediaDescription description = (MediaDescription)mediaDescription;
                for (Object descriptionAttribute : description.getAttributes(false)) {
                    Attribute attribute = (Attribute)descriptionAttribute;
                    switch (attribute.getName()) {
                        case "ice-ufrag": {
                            stream.setRemoteUfrag(attribute.getValue());
                            break;
                        }
                        case "ice-pwd": {
                            stream.setRemotePassword(attribute.getValue());
                            break;
                        }
                        case "fingerprint": {
                            fingerprint = attribute.getValue().split(" ")[1];
                        }
                    }
                }
            }
            this.component = this.agent.createComponent(stream, KeepAliveStrategy.SELECTED_ONLY, true);
            this.component.getSocket().setSoTimeout(20000);
            CustomDatagramTransport transport = new CustomDatagramTransport();
            DtlsClient client = new DtlsClient(new JcaTlsCryptoProvider().create(SecureRandom.getInstanceStrong()), fingerprint, this.rtcWebsocket.logger());
            SessionDescription answer = factory.createSessionDescription();
            answer.setOrigin(factory.createOrigin("-", Math.abs(new Random().nextLong()), 2L, "IN", "IP4", "127.0.0.1"));
            Vector<Attribute> attributes = new Vector<Attribute>();
            attributes.add(factory.createAttribute("group", "BUNDLE 0"));
            attributes.add(factory.createAttribute("extmap-allow-mixed", ""));
            attributes.add(factory.createAttribute("msid-semantic", " WMS"));
            answer.setAttributes(attributes);
            MediaDescription media = factory.createMediaDescription("application", 9, 0, "UDP/DTLS/SCTP", new String[]{"webrtc-datachannel"});
            media.setConnection(factory.createConnection("IN", "IP4", "0.0.0.0"));
            media.setAttribute("ice-ufrag", this.agent.getLocalUfrag());
            media.setAttribute("ice-pwd", this.agent.getLocalPassword());
            media.setAttribute("ice-options", "trickle");
            media.setAttribute("fingerprint", "sha-256 " + client.getClientFingerprint());
            media.setAttribute("setup", "active");
            media.setAttribute("mid", "0");
            media.setAttribute("sctp-port", String.valueOf(this.getComponentPort(5000)));
            media.setAttribute("max-message-size", "262144");
            answer.setMediaDescriptions(new Vector<MediaDescription>(Collections.of(media)));
            String json = Constants.GSON.toJson(new WsToMessage(1, from, "CONNECTRESPONSE " + sessionId + " " + String.valueOf(answer)));
            this.rtcWebsocket.send(json);
            this.agent.addStateChangeListener(evt -> {
                if (!"IceProcessingState".equals(evt.getPropertyName())) {
                    return;
                }
                if (IceProcessingState.COMPLETED.equals(evt.getNewValue())) {
                    this.rtcWebsocket.scheduledExecutorService().schedule(() -> {
                        if (this.agent.getState() != IceProcessingState.TERMINATED && (this.dtlsTransport == null || this.threadedAssociation == null)) {
                            this.rtcWebsocket.logger().error("Failure to create connection to the client after 15s, please try again");
                            this.disconnect();
                        }
                    }, 15L, TimeUnit.SECONDS);
                    try {
                        transport.init(this.component);
                        this.dtlsTransport = new DTLSClientProtocol().connect(client, transport);
                        this.threadedAssociation = new CachedThreadedAssociation((DatagramTransport)this.dtlsTransport, (AssociationListener)new SctpAssociationListener(this.rtcWebsocket.sessionInfo(), this.rtcWebsocket.logger(), this::disconnect, this.sessionManager), this.rtcWebsocket.scheduledExecutorService());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (IceProcessingState.FAILED.equals(evt.getNewValue())) {
                    this.rtcWebsocket.logger().error("Failure to establish ICE connection, likely due to a network issue. Please check Xbox Live status and firewall configuration.");
                    this.disconnect();
                }
            });
            this.rtcWebsocket.scheduledExecutorService().schedule(() -> {
                if (!this.hadFirstCandidate) {
                    this.disconnect();
                }
            }, 15L, TimeUnit.SECONDS);
            int i = 0;
            for (LocalCandidate candidate : this.component.getLocalCandidates()) {
                String jsonAdd = Constants.GSON.toJson(new WsToMessage(1, from, "CANDIDATEADD " + sessionId + " " + candidate.toString() + " generation 0 ufrag " + this.agent.getLocalUfrag() + " network-id " + i + " network-cost 0"));
                ++i;
                this.rtcWebsocket.send(jsonAdd);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addCandidate(String message) {
        this.component.addRemoteCandidate(this.parseCandidate(message, this.component.getParentStream()));
        this.lastCandidateTime = System.currentTimeMillis();
        if (!this.hadFirstCandidate && this.agent.getState() == IceProcessingState.WAITING) {
            this.hadFirstCandidate = true;
            new Thread(() -> {
                try {
                    while (System.currentTimeMillis() - this.lastCandidateTime < 200L) {
                        Thread.sleep(200L);
                    }
                    this.agent.startConnectivityEstablishment();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }).start();
        }
    }

    private RemoteCandidate parseCandidate(String value2, IceMediaStream stream) {
        StringTokenizer tokenizer = new StringTokenizer(value2);
        String foundation = tokenizer.nextToken();
        int componentID = Integer.parseInt(tokenizer.nextToken());
        Transport transport = Transport.parse(tokenizer.nextToken());
        long priority = Long.parseLong(tokenizer.nextToken());
        String address = tokenizer.nextToken();
        int port = Integer.parseInt(tokenizer.nextToken());
        TransportAddress transAddr = new TransportAddress(address, port, transport);
        tokenizer.nextToken();
        CandidateType type = CandidateType.parse(tokenizer.nextToken());
        Component component = stream.getComponent(componentID);
        if (component == null) {
            return null;
        }
        RemoteCandidate relatedCandidate = null;
        String ufrag = null;
        while (tokenizer.countTokens() >= 2) {
            String key = tokenizer.nextToken();
            String val = tokenizer.nextToken();
            if (key.equals("ufrag")) {
                ufrag = val;
                break;
            }
            if (!key.equals("raddr")) continue;
            tokenizer.nextToken();
            int relatedPort = Integer.parseInt(tokenizer.nextToken());
            TransportAddress raddr = new TransportAddress(val, relatedPort, Transport.UDP);
            relatedCandidate = component.findRemoteCandidate(raddr);
        }
        return new RemoteCandidate(transAddr, component, type, foundation, priority, relatedCandidate, ufrag);
    }

    private int getComponentPort(int fallback) {
        int port = fallback;
        for (LocalCandidate localCandidate : this.component.getLocalCandidates()) {
            if (localCandidate.getType() != CandidateType.HOST_CANDIDATE) continue;
            port = localCandidate.getTransportAddress().getPort();
            break;
        }
        return port;
    }

    private void disconnect() {
        try {
            if (this.threadedAssociation != null) {
                this.threadedAssociation.closeAllStreams();
            }
            if (this.dtlsTransport != null) {
                this.dtlsTransport.close();
            }
            if (this.component != null) {
                this.component.getSocket().close();
            }
            this.agent.free();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.rtcWebsocket.handleDisconnect(this.sessionId);
    }
}

