/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.webrtc.MinecraftDataHandler;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.AssociationListener;
import pe.pi.sctp4j.sctp.SCTPStream;

public class SctpAssociationListener
implements AssociationListener {
    private final SessionInfo sessionInfo;
    private final Runnable onDisconnect;
    private final Logger logger;
    private final SessionManagerCore sessionManager;

    public SctpAssociationListener(SessionInfo sessionInfo, Logger logger, Runnable onDisconnect, SessionManagerCore sessionManager) {
        this.sessionInfo = sessionInfo;
        this.logger = logger.prefixed("SctpAssociationListener");
        this.onDisconnect = onDisconnect;
        this.sessionManager = sessionManager;
    }

    @Override
    public void onAssociated(Association association) {
        this.logger.debug("SCTP session associated");
    }

    @Override
    public void onDisAssociated(Association association) {
        this.onDisconnect.run();
    }

    @Override
    public void onDCEPStream(SCTPStream sctpStream, String label, int i) {
        if (label == null) {
            return;
        }
        this.logger.debug("Received DCEP SCTP stream: " + sctpStream.toString());
        if ("ReliableDataChannel".equals(label)) {
            sctpStream.setSCTPStreamListener(new MinecraftDataHandler(sctpStream, Constants.BEDROCK_CODEC, this.sessionInfo, this.logger, this.sessionManager));
        }
    }

    @Override
    public void onRawStream(SCTPStream sctpStream) {
    }
}

