/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc.bedrock;

import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.webrtc.MinecraftDataHandler;
import com.rtm516.mcxboxbroadcast.core.webrtc.Utils;
import java.io.IOException;
import java.time.Instant;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.AuthoritativeMovementMode;
import org.cloudburstmc.protocol.bedrock.data.ChatRestrictionLevel;
import org.cloudburstmc.protocol.bedrock.data.EduSharedUriResource;
import org.cloudburstmc.protocol.bedrock.data.GamePublishSetting;
import org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.cloudburstmc.protocol.bedrock.data.SpawnBiomeType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.ClientCacheStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.DisconnectPacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.RequestNetworkSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePackClientResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePackStackPacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.bedrock.packet.TransferPacket;
import org.cloudburstmc.protocol.bedrock.util.ChainValidationResult;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.cloudburstmc.protocol.common.util.OptionalBoolean;

public class RedirectPacketHandler
implements BedrockPacketHandler {
    private final MinecraftDataHandler dataHandler;
    private final SessionInfo sessionInfo;
    private ChainValidationResult.IdentityData identityData;
    private boolean networkSettingsRequested = false;

    public RedirectPacketHandler(MinecraftDataHandler dataHandler, SessionInfo sessionInfo) {
        this.dataHandler = dataHandler;
        this.sessionInfo = sessionInfo;
    }

    private void disconnect(String message) {
        DisconnectPacket disconnectPacket = new DisconnectPacket();
        if (message == null) {
            disconnectPacket.setMessageSkipped(true);
            message = "disconnect.disconnected";
        }
        disconnectPacket.setKickMessage(message);
        this.dataHandler.sendPacket(disconnectPacket);
    }

    private void disconnect() {
        this.disconnect(null);
    }

    @Override
    public PacketSignal handlePacket(BedrockPacket packet) {
        BedrockPacketHandler.super.handlePacket(packet);
        return PacketSignal.HANDLED;
    }

    private boolean setCorrectCodec(int protocolVersion) {
        return true;
    }

    @Override
    public PacketSignal handle(RequestNetworkSettingsPacket packet) {
        if (!this.setCorrectCodec(packet.getProtocolVersion())) {
            return PacketSignal.HANDLED;
        }
        PacketCompressionAlgorithm algorithm = PacketCompressionAlgorithm.ZLIB;
        NetworkSettingsPacket responsePacket = new NetworkSettingsPacket();
        responsePacket.setCompressionAlgorithm(algorithm);
        responsePacket.setCompressionThreshold(512);
        this.dataHandler.sendPacket(responsePacket);
        this.dataHandler.enableCompression(algorithm, 512);
        this.networkSettingsRequested = true;
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(LoginPacket packet) {
        if (!this.networkSettingsRequested) {
            PlayStatusPacket statusPacket = new PlayStatusPacket();
            statusPacket.setStatus(PlayStatusPacket.Status.LOGIN_FAILED_CLIENT_OLD);
            this.dataHandler.sendPacket(statusPacket);
            this.disconnect();
            return PacketSignal.HANDLED;
        }
        PlayStatusPacket status = new PlayStatusPacket();
        status.setStatus(PlayStatusPacket.Status.LOGIN_SUCCESS);
        this.dataHandler.sendPacket(status);
        ResourcePacksInfoPacket info = new ResourcePacksInfoPacket();
        info.setWorldTemplateId(UUID.randomUUID());
        info.setWorldTemplateVersion("*");
        info.setVibrantVisualsForceDisabled(true);
        info.setForcedToAccept(false);
        this.dataHandler.sendPacket(info);
        try {
            this.identityData = Utils.validateConnection(this.dataHandler, packet.getAuthPayload(), packet.getClientJwt());
        }
        catch (AssertionError | Exception error) {
            this.disconnect("disconnect.loginFailed");
        }
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ClientCacheStatusPacket packet) {
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ResourcePackClientResponsePacket packet) {
        switch (packet.getStatus()) {
            case COMPLETED: {
                this.sendStartGame();
                break;
            }
            case HAVE_ALL_PACKS: {
                ResourcePackStackPacket stack = new ResourcePackStackPacket();
                stack.setExperimentsPreviouslyToggled(false);
                stack.setForcedToAccept(false);
                stack.setGameVersion("*");
                this.dataHandler.sendPacket(stack);
                break;
            }
            default: {
                this.disconnect("disconnectionScreen.resourcePack");
            }
        }
        return PacketSignal.HANDLED;
    }

    public void sendStartGame() {
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.setUniqueEntityId(1L);
        startGamePacket.setRuntimeEntityId(1L);
        startGamePacket.setPlayerGameType(GameType.CREATIVE);
        startGamePacket.setPlayerPosition(Vector3f.from(0.0f, 66.0f, 0.0f));
        startGamePacket.setRotation(Vector2f.ONE);
        startGamePacket.setPlayerPropertyData(NbtMap.EMPTY);
        startGamePacket.setSeed(0L);
        startGamePacket.setDimensionId(2);
        startGamePacket.setGeneratorId(1);
        startGamePacket.setSpawnBiomeType(SpawnBiomeType.DEFAULT);
        startGamePacket.setCustomBiomeName("");
        startGamePacket.setForceExperimentalGameplay(OptionalBoolean.empty());
        startGamePacket.setLevelGameType(GameType.CREATIVE);
        startGamePacket.setDifficulty(0);
        startGamePacket.setDefaultSpawn(Vector3i.ZERO);
        startGamePacket.setAchievementsDisabled(true);
        startGamePacket.setCurrentTick(-1L);
        startGamePacket.setEduEditionOffers(0);
        startGamePacket.setEduFeaturesEnabled(false);
        startGamePacket.setEducationProductionId("");
        startGamePacket.setEduSharedUriResource(EduSharedUriResource.EMPTY);
        startGamePacket.setRainLevel(0.0f);
        startGamePacket.setLightningLevel(0.0f);
        startGamePacket.setMultiplayerGame(true);
        startGamePacket.setBroadcastingToLan(true);
        startGamePacket.getGamerules().add(new GameRuleData<Boolean>("showcoordinates", false));
        startGamePacket.setPlatformBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setXblBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setCommandsEnabled(true);
        startGamePacket.setChatRestrictionLevel(ChatRestrictionLevel.NONE);
        startGamePacket.setTexturePacksRequired(false);
        startGamePacket.setBonusChestEnabled(false);
        startGamePacket.setStartingWithMap(false);
        startGamePacket.setTrustingPlayers(true);
        startGamePacket.setDefaultPlayerPermission(PlayerPermission.VISITOR);
        startGamePacket.setServerChunkTickRange(4);
        startGamePacket.setBehaviorPackLocked(false);
        startGamePacket.setResourcePackLocked(false);
        startGamePacket.setFromLockedWorldTemplate(false);
        startGamePacket.setUsingMsaGamertagsOnly(false);
        startGamePacket.setFromWorldTemplate(false);
        startGamePacket.setWorldTemplateOptionLocked(false);
        startGamePacket.setServerEngine("");
        startGamePacket.setLevelId("");
        startGamePacket.setLevelName("MCXboxBroadcast");
        startGamePacket.setPremiumWorldTemplateId("");
        startGamePacket.setWorldTemplateId(new UUID(0L, 0L));
        startGamePacket.setCurrentTick(0L);
        startGamePacket.setEnchantmentSeed(0);
        startGamePacket.setMultiplayerCorrelationId("");
        startGamePacket.setVanillaVersion("*");
        startGamePacket.setAuthoritativeMovementMode(AuthoritativeMovementMode.SERVER);
        startGamePacket.setRewindHistorySize(0);
        startGamePacket.setServerAuthoritativeBlockBreaking(false);
        startGamePacket.setServerId("");
        startGamePacket.setWorldId("");
        startGamePacket.setScenarioId("");
        startGamePacket.setOwnerId("");
        this.dataHandler.sendPacket(startGamePacket);
        TransferPacket transferPacket = new TransferPacket();
        transferPacket.setAddress(this.sessionInfo.getIp());
        transferPacket.setPort(this.sessionInfo.getPort());
        this.dataHandler.sendPacket(transferPacket);
        try {
            if (this.identityData != null) {
                this.dataHandler.sessionManager().logger().info("Transferred bedrock client " + this.identityData.displayName + " (" + this.identityData.xuid + ") to target server.");
                this.dataHandler.sessionManager().storageManager().playerHistory().lastSeen(this.identityData.xuid, Instant.now());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

