/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc.compression;

import com.rtm516.mcxboxbroadcast.core.webrtc.compression.CompressionCodec;
import com.rtm516.mcxboxbroadcast.core.webrtc.compression.NoneCompressionCodec;
import com.rtm516.mcxboxbroadcast.core.webrtc.compression.ZlibCompressionCodec;
import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;

public class CompressionHandler {
    private final CompressionCodec chosenCodec;
    private final NoneCompressionCodec fallback;
    private final int threshold;

    public CompressionHandler(PacketCompressionAlgorithm algorithm, int threshold) {
        NoneCompressionCodec codec;
        CompressionCodec compressionCodec = this.chosenCodec = (switch (algorithm) {
            case PacketCompressionAlgorithm.ZLIB -> new ZlibCompressionCodec();
            case PacketCompressionAlgorithm.NONE -> new NoneCompressionCodec();
            default -> throw new IllegalArgumentException("Unsupported compression algorithm: " + String.valueOf(algorithm));
        });
        this.fallback = compressionCodec instanceof NoneCompressionCodec ? (codec = (NoneCompressionCodec)compressionCodec) : new NoneCompressionCodec();
        this.threshold = threshold;
    }

    public ByteBuf encode(ByteBuf buf) throws Exception {
        if (buf.readableBytes() > this.threshold) {
            return this.chosenCodec.encode(buf);
        }
        return this.fallback.encode(buf);
    }

    public ByteBuf decode(ByteBuf buf) throws Exception {
        if (buf.readableBytes() > this.threshold) {
            return this.chosenCodec.decode(buf);
        }
        return this.fallback.decode(buf);
    }
}

