/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc.compression;

import com.rtm516.mcxboxbroadcast.core.webrtc.compression.CompressionCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.cloudburstmc.protocol.common.util.Zlib;

public class ZlibCompressionCodec
implements CompressionCodec {
    private static final int MAX_DECOMPRESSED_BYTES = Integer.getInteger("bedrock.maxDecompressedBytes", 0xA00000);
    private final Zlib zlib = Zlib.RAW;
    private final int level = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBuf msg) throws Exception {
        ByteBuf outBuf = Unpooled.buffer(msg.readableBytes() << 4);
        outBuf.writeByte(this.compressionIdentifier());
        try {
            this.zlib.deflate(msg, outBuf, 7);
            ByteBuf byteBuf = outBuf.retain();
            return byteBuf;
        }
        finally {
            outBuf.release();
        }
    }

    @Override
    public ByteBuf decode(ByteBuf msg) throws Exception {
        if (msg.readUnsignedByte() != this.compressionIdentifier()) {
            throw new IllegalArgumentException("Unexpected compression identifier");
        }
        return this.zlib.inflate(msg, MAX_DECOMPRESSED_BYTES);
    }

    @Override
    public int compressionIdentifier() {
        return 0;
    }
}

