/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.java;

import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.MinecraftResponseHandler;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.AbstractStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.JsonContent;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.logging.ILogger;
import java.time.Instant;
import java.time.ZoneId;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;

public class StepMCToken
extends AbstractStep<StepXblXstsToken.XblXsts<?>, MCToken> {
    public static final String MINECRAFT_LOGIN_URL = "https://api.minecraftservices.com/launcher/login";

    public StepMCToken(AbstractStep<?, ? extends StepXblXstsToken.XblXsts<?>> prevStep) {
        super("mcToken", prevStep);
    }

    @Override
    protected MCToken execute(ILogger logger, HttpClient httpClient, StepXblXstsToken.XblXsts<?> xblXsts) throws Exception {
        logger.info(this, "Authenticating with Minecraft Services...");
        JsonObject postData = new JsonObject();
        postData.addProperty("platform", "PC_LAUNCHER");
        postData.addProperty("xtoken", "XBL3.0 x=" + xblXsts.getServiceToken());
        PostRequest postRequest = new PostRequest(MINECRAFT_LOGIN_URL);
        postRequest.setContent(new JsonContent(postData));
        JsonObject obj = httpClient.execute(postRequest, new MinecraftResponseHandler());
        MCToken mcToken = new MCToken(obj.get("access_token").getAsString(), obj.get("token_type").getAsString(), System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, xblXsts);
        logger.info(this, "Got MC Token, expires: " + Instant.ofEpochMilli(mcToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return mcToken;
    }

    @Override
    public MCToken fromJson(JsonObject json) {
        StepXblXstsToken.XblXsts xblXsts = this.prevStep != null ? (StepXblXstsToken.XblXsts)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new MCToken(json.get("accessToken").getAsString(), json.get("tokenType").getAsString(), json.get("expireTimeMs").getAsLong(), xblXsts);
    }

    @Override
    public JsonObject toJson(MCToken mcToken) {
        JsonObject json = new JsonObject();
        json.addProperty("accessToken", mcToken.accessToken);
        json.addProperty("tokenType", mcToken.tokenType);
        json.addProperty("expireTimeMs", mcToken.expireTimeMs);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, this.prevStep.toJson(mcToken.xblXsts));
        }
        return json;
    }

    public static final class MCToken
    extends AbstractStep.StepResult<StepXblXstsToken.XblXsts<?>> {
        private final String accessToken;
        private final String tokenType;
        private final long expireTimeMs;
        private final StepXblXstsToken.XblXsts<?> xblXsts;

        @Override
        protected StepXblXstsToken.XblXsts<?> prevResult() {
            return this.xblXsts;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis() || this.prevResult().isExpired();
        }

        @Generated
        public MCToken(String accessToken, String tokenType, long expireTimeMs, StepXblXstsToken.XblXsts<?> xblXsts) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.expireTimeMs = expireTimeMs;
            this.xblXsts = xblXsts;
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public String getTokenType() {
            return this.tokenType;
        }

        @Generated
        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        @Generated
        public StepXblXstsToken.XblXsts<?> getXblXsts() {
            return this.xblXsts;
        }

        @Generated
        public String toString() {
            return "StepMCToken.MCToken(accessToken=" + this.getAccessToken() + ", tokenType=" + this.getTokenType() + ", expireTimeMs=" + this.getExpireTimeMs() + ", xblXsts=" + this.getXblXsts() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MCToken)) {
                return false;
            }
            MCToken other = (MCToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$tokenType = this.getTokenType();
            String other$tokenType = other.getTokenType();
            if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
                return false;
            }
            StepXblXstsToken.XblXsts<?> this$xblXsts = this.getXblXsts();
            StepXblXstsToken.XblXsts<?> other$xblXsts = other.getXblXsts();
            return !(this$xblXsts == null ? other$xblXsts != null : !this$xblXsts.equals(other$xblXsts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MCToken;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $tokenType = this.getTokenType();
            result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
            StepXblXstsToken.XblXsts<?> $xblXsts = this.getXblXsts();
            result = result * 59 + ($xblXsts == null ? 43 : $xblXsts.hashCode());
            return result;
        }
    }
}

