/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa;

import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.AbstractStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.InitialPreparationStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.logging.ILogger;
import java.net.ServerSocket;
import java.net.URL;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.utils.URLWrapper;

public class StepLocalWebServer
extends InitialPreparationStep<LocalWebServerCallback, LocalWebServer> {
    public StepLocalWebServer(AbstractStep.ApplicationDetails applicationDetails) {
        super("localWebServer", applicationDetails);
        if (applicationDetails.getRedirectUri().endsWith("/")) {
            throw new IllegalArgumentException("Redirect URI must not end with a slash");
        }
    }

    @Override
    protected LocalWebServer execute(ILogger logger, HttpClient httpClient, LocalWebServerCallback localWebServerCallback) throws Exception {
        logger.info(this, "Creating URL for MSA login via local webserver...");
        if (localWebServerCallback == null) {
            throw new IllegalStateException("Missing StepLocalWebServer.LocalWebServerCallback input");
        }
        try (ServerSocket localServer = new ServerSocket(0);){
            int localPort = localServer.getLocalPort();
            String customRedirectUri = this.applicationDetails.getRedirectUri() + ":" + localPort;
            URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).setQuery("redirect_uri", customRedirectUri).setQuery("prompt", "select_account").apply().toURL();
            LocalWebServer localWebServer = new LocalWebServer(authenticationUrl.toString(), localPort, customRedirectUri);
            logger.info(this, "Created local webserver MSA authentication URL: " + localWebServer.getAuthenticationUrl());
            localWebServerCallback.callback.accept(localWebServer);
            LocalWebServer localWebServer2 = localWebServer;
            return localWebServer2;
        }
    }

    public static final class LocalWebServerCallback
    extends AbstractStep.InitialInput {
        private final Consumer<LocalWebServer> callback;

        @Generated
        public LocalWebServerCallback(Consumer<LocalWebServer> callback) {
            this.callback = callback;
        }

        @Generated
        public Consumer<LocalWebServer> getCallback() {
            return this.callback;
        }

        @Generated
        public String toString() {
            return "StepLocalWebServer.LocalWebServerCallback(callback=" + this.getCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServerCallback)) {
                return false;
            }
            LocalWebServerCallback other = (LocalWebServerCallback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<LocalWebServer> this$callback = this.getCallback();
            Consumer<LocalWebServer> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServerCallback;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<LocalWebServer> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }
    }

    public static final class LocalWebServer
    extends AbstractStep.InitialInput {
        private final String authenticationUrl;
        private final int port;
        private final String customRedirectUri;

        @Generated
        public LocalWebServer(String authenticationUrl, int port, String customRedirectUri) {
            this.authenticationUrl = authenticationUrl;
            this.port = port;
            this.customRedirectUri = customRedirectUri;
        }

        @Generated
        public String getAuthenticationUrl() {
            return this.authenticationUrl;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getCustomRedirectUri() {
            return this.customRedirectUri;
        }

        @Generated
        public String toString() {
            return "StepLocalWebServer.LocalWebServer(authenticationUrl=" + this.getAuthenticationUrl() + ", port=" + this.getPort() + ", customRedirectUri=" + this.getCustomRedirectUri() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServer)) {
                return false;
            }
            LocalWebServer other = (LocalWebServer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$authenticationUrl = this.getAuthenticationUrl();
            String other$authenticationUrl = other.getAuthenticationUrl();
            if (this$authenticationUrl == null ? other$authenticationUrl != null : !this$authenticationUrl.equals(other$authenticationUrl)) {
                return false;
            }
            String this$customRedirectUri = this.getCustomRedirectUri();
            String other$customRedirectUri = other.getCustomRedirectUri();
            return !(this$customRedirectUri == null ? other$customRedirectUri != null : !this$customRedirectUri.equals(other$customRedirectUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $authenticationUrl = this.getAuthenticationUrl();
            result = result * 59 + ($authenticationUrl == null ? 43 : $authenticationUrl.hashCode());
            String $customRedirectUri = this.getCustomRedirectUri();
            result = result * 59 + ($customRedirectUri == null ? 43 : $customRedirectUri.hashCode());
            return result;
        }
    }
}

