/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa;

import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.exception.MsaRequestException;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.AbstractStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.StepLocalWebServer;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.logging.ILogger;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.utils.URLWrapper;

public class StepLocalWebServerMsaCode
extends MsaCodeStep<StepLocalWebServer.LocalWebServer> {
    private final int timeout;

    public StepLocalWebServerMsaCode(AbstractStep<?, StepLocalWebServer.LocalWebServer> prevStep, int timeout2) {
        super(prevStep);
        this.timeout = timeout2;
    }

    @Override
    protected MsaCodeStep.MsaCode execute(ILogger logger, HttpClient httpClient, StepLocalWebServer.LocalWebServer localWebServer) throws Exception {
        logger.info(this, "Waiting for MSA login via local webserver...");
        CompletableFuture msaCodeFuture = new CompletableFuture();
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(localWebServer.getPort()), 0);
        httpServer.createContext("/", httpExchange -> {
            try {
                Map<String, String> parameters = new URLWrapper(httpExchange.getRequestURI()).wrapQuery().getQueries();
                if (parameters.containsKey("error") && parameters.containsKey("error_description")) {
                    HttpResponse fakeResponse = new HttpResponse(null, 500, new byte[0], Collections.emptyMap());
                    throw new MsaRequestException(fakeResponse, parameters.get("error"), parameters.get("error_description"));
                }
                if (!parameters.containsKey("code")) {
                    throw new IllegalStateException("Could not extract MSA Code from response url");
                }
                byte[] response = "You have been logged in! You can now close this window.".getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(200, response.length);
                httpExchange.getResponseBody().write(response);
                httpExchange.close();
                msaCodeFuture.complete(new MsaCodeStep.MsaCode(parameters.get("code")));
            }
            catch (Throwable e) {
                byte[] response = ("Login failed. Error message: " + e.getMessage()).getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(500, response.length);
                httpExchange.getResponseBody().write(response);
                httpExchange.close();
                msaCodeFuture.completeExceptionally(e);
            }
        });
        httpServer.start();
        try {
            MsaCodeStep.MsaCode msaCode = (MsaCodeStep.MsaCode)msaCodeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            msaCode.customRedirectUri = localWebServer.getCustomRedirectUri();
            httpServer.stop(0);
            logger.info(this, "Got MSA Code");
            return msaCode;
        }
        catch (TimeoutException e) {
            httpServer.stop(0);
            throw new TimeoutException("MSA login timed out");
        }
        catch (ExecutionException e) {
            httpServer.stop(0);
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

