/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.security.DefaultSecureRequest;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class JwtUtil {
    public static Jwt parseSignedJwt(String jwt, PublicKey publicKey) {
        final Jws<Claims> parsedJwt = Jwts.parser().clockSkewSeconds(60L).verifyWith(publicKey).build().parseSignedClaims(jwt);
        return new Jwt(){

            @Override
            public <T> T getClaim(String claimName, Class<T> requiredType) {
                return ((Claims)parsedJwt.getPayload()).get(claimName, requiredType);
            }
        };
    }

    public static byte[] signES256(PrivateKey privateKey, byte[] data) {
        return Jwts.SIG.ES256.digest(new DefaultSecureRequest<ByteArrayInputStream, PrivateKey>(new ByteArrayInputStream(data), null, null, privateKey));
    }

    public static interface Jwt {
        public <T> T getClaim(String var1, Class<T> var2);
    }
}

