/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.isismtt.x509;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Integer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Object;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1PrintableString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Sequence;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERPrintableString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class MonetaryLimit
extends ASN1Object {
    ASN1PrintableString currency;
    ASN1Integer amount;
    ASN1Integer exponent;

    public static MonetaryLimit getInstance(Object object) {
        if (object == null || object instanceof MonetaryLimit) {
            return (MonetaryLimit)object;
        }
        if (object instanceof ASN1Sequence) {
            return new MonetaryLimit(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    private MonetaryLimit(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.currency = ASN1PrintableString.getInstance(enumeration.nextElement());
        this.amount = ASN1Integer.getInstance(enumeration.nextElement());
        this.exponent = ASN1Integer.getInstance(enumeration.nextElement());
    }

    public MonetaryLimit(String string, int n, int n2) {
        this.currency = new DERPrintableString(string, true);
        this.amount = new ASN1Integer(n);
        this.exponent = new ASN1Integer(n2);
    }

    public String getCurrency() {
        return this.currency.getString();
    }

    public BigInteger getAmount() {
        return this.amount.getValue();
    }

    public BigInteger getExponent() {
        return this.exponent.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.currency);
        aSN1EncodableVector.add(this.amount);
        aSN1EncodableVector.add(this.exponent);
        return new DERSequence(aSN1EncodableVector);
    }
}

