/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CMPCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CertResponse;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSEnvelopedData;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.Recipient;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.RecipientInformation;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.RecipientInformationStore;
import java.util.Collection;

public class CertificateResponse {
    private final CertResponse certResponse;

    public CertificateResponse(CertResponse certResponse) {
        this.certResponse = certResponse;
    }

    public boolean hasEncryptedCertificate() {
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().hasEncryptedCertificate();
    }

    public CMSEnvelopedData getEncryptedCertificate() throws CMSException {
        if (!this.hasEncryptedCertificate()) {
            throw new IllegalStateException("encrypted certificate asked for, none found");
        }
        CertifiedKeyPair certifiedKeyPair = this.certResponse.getCertifiedKeyPair();
        CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(new ContentInfo(PKCSObjectIdentifiers.envelopedData, certifiedKeyPair.getCertOrEncCert().getEncryptedCert().getValue()));
        if (cMSEnvelopedData.getRecipientInfos().size() != 1) {
            throw new IllegalStateException("data encrypted for more than one recipient");
        }
        return cMSEnvelopedData;
    }

    public CMPCertificate getCertificate(Recipient recipient) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.getEncryptedCertificate();
        RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
        Collection<RecipientInformation> collection = recipientInformationStore.getRecipients();
        RecipientInformation recipientInformation = collection.iterator().next();
        return CMPCertificate.getInstance(recipientInformation.getContent(recipient));
    }

    public CMPCertificate getCertificate() throws CMSException {
        if (this.hasEncryptedCertificate()) {
            throw new IllegalStateException("plaintext certificate asked for, none found");
        }
        return this.certResponse.getCertifiedKeyPair().getCertOrEncCert().getCertificate();
    }

    public CertResponse toASN1Structure() {
        return this.certResponse;
    }
}

