/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.EnvelopedData;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.crmf.EncKeyWithID;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.crmf.EncryptedKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.GeneralName;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf.PKIArchiveControl;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSEnvelopedData;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSProcessableByteArray;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.RecipientInfoGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

