/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf.CRMFException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CipherParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.KeyParameter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.util.CipherFactory;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.util.CipherKeyGeneratorFactory;
import java.security.SecureRandom;

class CRMFHelper {
    CRMFHelper() {
    }

    CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, SecureRandom secureRandom) throws CRMFException {
        try {
            return CipherKeyGeneratorFactory.createKeyGenerator(aSN1ObjectIdentifier, secureRandom);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CRMFException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    static Object createContentCipher(boolean bl, CipherParameters cipherParameters, AlgorithmIdentifier algorithmIdentifier) throws CRMFException {
        try {
            return CipherFactory.createContentCipher(bl, cipherParameters, algorithmIdentifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CRMFException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    AlgorithmIdentifier generateEncryptionAlgID(ASN1ObjectIdentifier aSN1ObjectIdentifier, KeyParameter keyParameter, SecureRandom secureRandom) throws CRMFException {
        try {
            return AlgorithmIdentifierFactory.generateEncryptionAlgID(aSN1ObjectIdentifier, keyParameter.getKey().length * 8, secureRandom);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CRMFException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

