/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cmc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.X509CRLHolder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cmc.CMCException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSSignedData;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Encodable;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Store;
import java.io.IOException;

public class SimplePKIResponse
implements Encodable {
    private final CMSSignedData certificateResponse;

    private static ContentInfo parseBytes(byte[] byArray) throws CMCException {
        try {
            return ContentInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (Exception exception) {
            throw new CMCException("malformed data: " + exception.getMessage(), exception);
        }
    }

    public SimplePKIResponse(byte[] byArray) throws CMCException {
        this(SimplePKIResponse.parseBytes(byArray));
    }

    public SimplePKIResponse(ContentInfo contentInfo) throws CMCException {
        try {
            this.certificateResponse = new CMSSignedData(contentInfo);
        }
        catch (CMSException cMSException) {
            throw new CMCException("malformed response: " + cMSException.getMessage(), cMSException);
        }
        if (this.certificateResponse.getSignerInfos().size() != 0) {
            throw new CMCException("malformed response: SignerInfo structures found");
        }
        if (this.certificateResponse.getSignedContent() != null) {
            throw new CMCException("malformed response: Signed Content found");
        }
    }

    public Store<X509CertificateHolder> getCertificates() {
        return this.certificateResponse.getCertificates();
    }

    public Store<X509CRLHolder> getCRLs() {
        return this.certificateResponse.getCRLs();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificateResponse.getEncoded();
    }
}

