/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1OctetString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.RecipientIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSSecureReadable;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.KeyTransRecipient;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.KeyTransRecipientId;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.Recipient;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.RecipientInformation;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

