/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DEROctetString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cms.SignerIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSAttributeTableGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cms.SignerInfoGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.ContentSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DigestCalculator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.OperatorCreationException;

public class SignerInfoGeneratorBuilder {
    private final DigestAlgorithmIdentifierFinder digAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private DigestCalculatorProvider digestProvider;
    private boolean directSignature;
    private CMSAttributeTableGenerator signedGen;
    private CMSAttributeTableGenerator unsignedGen;
    private CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder;
    private AlgorithmIdentifier contentDigest;

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this(digestCalculatorProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder) {
        this.digestProvider = digestCalculatorProvider;
        this.sigEncAlgFinder = cMSSignatureEncryptionAlgorithmFinder;
    }

    public SignerInfoGeneratorBuilder setDirectSignature(boolean bl) {
        this.directSignature = bl;
        return this;
    }

    public SignerInfoGeneratorBuilder setContentDigest(AlgorithmIdentifier algorithmIdentifier) {
        this.contentDigest = algorithmIdentifier;
        return this;
    }

    public SignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.signedGen = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.unsignedGen = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure()));
        SignerInfoGenerator signerInfoGenerator = this.createGenerator(contentSigner, signerIdentifier);
        signerInfoGenerator.setAssociatedCertificate(x509CertificateHolder);
        return signerInfoGenerator;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] byArray) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new DEROctetString(byArray));
        return this.createGenerator(contentSigner, signerIdentifier);
    }

    private SignerInfoGenerator createGenerator(ContentSigner contentSigner, SignerIdentifier signerIdentifier) throws OperatorCreationException {
        DigestCalculator digestCalculator = this.contentDigest != null ? this.digestProvider.get(this.contentDigest) : this.digestProvider.get(this.digAlgFinder.find(contentSigner.getAlgorithmIdentifier()));
        if (this.directSignature) {
            return new SignerInfoGenerator(signerIdentifier, contentSigner, digestCalculator.getAlgorithmIdentifier(), this.sigEncAlgFinder);
        }
        if (this.signedGen != null || this.unsignedGen != null) {
            if (this.signedGen == null) {
                this.signedGen = new DefaultSignedAttributeTableGenerator();
            }
            return new SignerInfoGenerator(signerIdentifier, contentSigner, digestCalculator, this.sigEncAlgFinder, this.signedGen, this.unsignedGen);
        }
        return new SignerInfoGenerator(signerIdentifier, contentSigner, digestCalculator, this.sigEncAlgFinder, new DefaultSignedAttributeTableGenerator(), null);
    }
}

