/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ec;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CipherParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ec.ECEncryptor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ec.ECPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ec.ECUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECAlgorithms;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECMultiplier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECPoint;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public ECPair encrypt(ECPoint eCPoint) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = ECUtil.generateK(eCDomainParameters.getN(), this.random);
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger), this.key.getQ().multiply(bigInteger).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPoint))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

