/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCSNIMatcher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCSNIServerName;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.IDNUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.NameType;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Strings;
import java.util.Locale;
import java.util.regex.Pattern;

public final class BCSNIHostName
extends BCSNIServerName {
    private final String hostName;

    public static BCSNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException("'regex' cannot be null");
        }
        return new BCSNIHostNameMatcher(string);
    }

    public BCSNIHostName(String string) {
        string = BCSNIHostName.normalizeHostName(string);
        super(0, Strings.toByteArray(string));
        this.hostName = string;
    }

    public BCSNIHostName(byte[] byArray) {
        super(0, byArray);
        this.hostName = BCSNIHostName.normalizeHostName(Strings.fromUTF8ByteArray(byArray));
    }

    public String getAsciiName() {
        return this.hostName;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BCSNIHostName)) {
            return false;
        }
        BCSNIHostName bCSNIHostName = (BCSNIHostName)object;
        return this.hostName.equalsIgnoreCase(bCSNIHostName.hostName);
    }

    @Override
    public int hashCode() {
        return this.hostName.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public String toString() {
        return "{type=" + NameType.getText((short)0) + ", value=" + this.hostName + "}";
    }

    private static String normalizeHostName(String string) {
        if (null == string) {
            throw new NullPointerException("'hostName' cannot be null");
        }
        if ((string = IDNUtil.toASCII(string, IDNUtil.USE_STD3_ASCII_RULES)).length() < 1) {
            throw new IllegalArgumentException("SNI host_name cannot be empty");
        }
        if (string.endsWith(".")) {
            throw new IllegalArgumentException("SNI host_name cannot end with a separator");
        }
        return string;
    }

    private static final class BCSNIHostNameMatcher
    extends BCSNIMatcher {
        private final Pattern pattern;

        BCSNIHostNameMatcher(String string) {
            super(0);
            this.pattern = Pattern.compile(string, 2);
        }

        @Override
        public boolean matches(BCSNIServerName bCSNIServerName) {
            String string;
            if (null == bCSNIServerName) {
                throw new NullPointerException("'serverName' cannot be null");
            }
            if (0 != bCSNIServerName.getType()) {
                return false;
            }
            try {
                string = this.getAsciiHostName(bCSNIServerName);
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            if (this.pattern.matcher(string).matches()) {
                return true;
            }
            String string2 = IDNUtil.toUnicode(string, 0);
            return !string.equals(string2) && this.pattern.matcher(string2).matches();
        }

        private String getAsciiHostName(BCSNIServerName bCSNIServerName) {
            if (bCSNIServerName instanceof BCSNIHostName) {
                return ((BCSNIHostName)bCSNIServerName).getAsciiName();
            }
            return BCSNIHostName.normalizeHostName(Strings.fromUTF8ByteArray(bCSNIServerName.getEncoded()));
        }
    }
}

