/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.NamedGroupInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.util.List;
import java.util.Vector;

final class ContextData {
    private final ProvSSLContextSpi context;
    private final JcaTlsCrypto crypto;
    private final BCX509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final NamedGroupInfo.PerContext namedGroups;
    private final SignatureSchemeInfo.PerContext signatureSchemes;

    ContextData(ProvSSLContextSpi provSSLContextSpi, JcaTlsCrypto jcaTlsCrypto, BCX509ExtendedKeyManager bCX509ExtendedKeyManager, BCX509ExtendedTrustManager bCX509ExtendedTrustManager) {
        this.context = provSSLContextSpi;
        this.crypto = jcaTlsCrypto;
        this.x509KeyManager = bCX509ExtendedKeyManager;
        this.x509TrustManager = bCX509ExtendedTrustManager;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.namedGroups = NamedGroupInfo.createPerContext(provSSLContextSpi.isFips(), jcaTlsCrypto);
        this.signatureSchemes = SignatureSchemeInfo.createPerContext(provSSLContextSpi.isFips(), jcaTlsCrypto, this.namedGroups);
    }

    NamedGroupInfo.PerConnection getNamedGroupsClient(ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        return NamedGroupInfo.createPerConnectionClient(this.namedGroups, provSSLParameters, protocolVersionArray);
    }

    NamedGroupInfo.PerConnection getNamedGroupsServer(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion) {
        return NamedGroupInfo.createPerConnectionServer(this.namedGroups, provSSLParameters, protocolVersion);
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesClient(ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray, NamedGroupInfo.PerConnection perConnection) {
        return SignatureSchemeInfo.createPerConnectionClient(this.signatureSchemes, provSSLParameters, protocolVersionArray, perConnection);
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesServer(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion, NamedGroupInfo.PerConnection perConnection) {
        return SignatureSchemeInfo.createPerConnectionServer(this.signatureSchemes, provSSLParameters, protocolVersion, perConnection);
    }

    ProvSSLContextSpi getContext() {
        return this.context;
    }

    JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> vector) {
        return SignatureSchemeInfo.getSignatureSchemes(this.signatureSchemes, vector);
    }

    BCX509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }
}

