/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCX509Key;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.JsseUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvX509KeyManager;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.TransportData;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;

class ProvX509Key
implements BCX509Key {
    private static final Logger LOG = Logger.getLogger(ProvX509Key.class.getName());
    private final String keyType;
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String string, String string2) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == string || null == string2) {
            return null;
        }
        X509Certificate[] x509CertificateArray = ProvX509Key.getCertificateChain(x509KeyManager, string2);
        if (null == x509CertificateArray) {
            return null;
        }
        PrivateKey privateKey = ProvX509Key.getPrivateKey(x509KeyManager, string2);
        if (null == privateKey) {
            return null;
        }
        return new ProvX509Key(string, privateKey, x509CertificateArray);
    }

    static ProvX509Key validate(X509KeyManager x509KeyManager, boolean bl, String string, String string2, TransportData transportData) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == string || null == string2) {
            return null;
        }
        X509Certificate[] x509CertificateArray = ProvX509Key.getCertificateChain(x509KeyManager, string2);
        if (null == x509CertificateArray) {
            return null;
        }
        if (!ProvX509KeyManager.isSuitableKeyType(bl, string, x509CertificateArray[0], transportData)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Rejecting alias '" + string2 + "': not suitable for key type '" + string + "'");
            }
            return null;
        }
        PrivateKey privateKey = ProvX509Key.getPrivateKey(x509KeyManager, string2);
        if (null == privateKey) {
            return null;
        }
        return new ProvX509Key(string, privateKey, x509CertificateArray);
    }

    private static X509Certificate[] getCertificateChain(X509KeyManager x509KeyManager, String string) {
        Object[] objectArray = x509KeyManager.getCertificateChain(string);
        if (TlsUtils.isNullOrEmpty(objectArray)) {
            LOG.finer("Rejecting alias '" + string + "': no certificate chain");
            return null;
        }
        if (JsseUtils.containsNull(objectArray = (X509Certificate[])objectArray.clone())) {
            LOG.finer("Rejecting alias '" + string + "': invalid certificate chain");
            return null;
        }
        return objectArray;
    }

    private static PrivateKey getPrivateKey(X509KeyManager x509KeyManager, String string) {
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string);
        if (null == privateKey) {
            LOG.finer("Rejecting alias '" + string + "': no private key");
            return null;
        }
        return privateKey;
    }

    ProvX509Key(String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.keyType = string;
        this.privateKey = privateKey;
        this.certificateChain = x509CertificateArray;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

