/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCExtendedSSLSession;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCSSLParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.JsseUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.SSLEngineUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.SSLSocketUtil;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;

class TransportData {
    private final BCSSLParameters parameters;
    private final BCExtendedSSLSession handshakeSession;

    static TransportData from(Socket socket) {
        if (!(socket instanceof SSLSocket) || !socket.isConnected()) {
            return null;
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        BCSSLParameters bCSSLParameters = SSLSocketUtil.importSSLParameters(sSLSocket);
        if (null == bCSSLParameters) {
            return null;
        }
        BCExtendedSSLSession bCExtendedSSLSession = SSLSocketUtil.importHandshakeSession(sSLSocket);
        return new TransportData(bCSSLParameters, bCExtendedSSLSession);
    }

    static TransportData from(SSLEngine sSLEngine) {
        if (null == sSLEngine) {
            return null;
        }
        BCSSLParameters bCSSLParameters = SSLEngineUtil.importSSLParameters(sSLEngine);
        if (null == bCSSLParameters) {
            return null;
        }
        BCExtendedSSLSession bCExtendedSSLSession = SSLEngineUtil.importHandshakeSession(sSLEngine);
        return new TransportData(bCSSLParameters, bCExtendedSSLSession);
    }

    static BCAlgorithmConstraints getAlgorithmConstraints(TransportData transportData, boolean bl) {
        return null == transportData ? ProvAlgorithmConstraints.DEFAULT : transportData.getAlgorithmConstraints(bl);
    }

    static List<byte[]> getStatusResponses(TransportData transportData) {
        return null == transportData ? Collections.emptyList() : transportData.getStatusResponses();
    }

    private TransportData(BCSSLParameters bCSSLParameters, BCExtendedSSLSession bCExtendedSSLSession) {
        this.parameters = bCSSLParameters;
        this.handshakeSession = bCExtendedSSLSession;
    }

    BCSSLParameters getParameters() {
        return this.parameters;
    }

    BCExtendedSSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    BCAlgorithmConstraints getAlgorithmConstraints(boolean bl) {
        BCAlgorithmConstraints bCAlgorithmConstraints = this.parameters.getAlgorithmConstraints();
        if (ProvAlgorithmConstraints.DEFAULT == bCAlgorithmConstraints) {
            bCAlgorithmConstraints = null;
        }
        if (null != this.handshakeSession && JsseUtils.isTLSv12(this.handshakeSession.getProtocol())) {
            String[] stringArray;
            String[] stringArray2 = stringArray = bl ? this.handshakeSession.getPeerSupportedSignatureAlgorithmsBC() : this.handshakeSession.getLocalSupportedSignatureAlgorithmsBC();
            if (null != stringArray) {
                return new ProvAlgorithmConstraints(bCAlgorithmConstraints, stringArray, true);
            }
        }
        return null == bCAlgorithmConstraints ? ProvAlgorithmConstraints.DEFAULT : new ProvAlgorithmConstraints(bCAlgorithmConstraints, true);
    }

    List<byte[]> getStatusResponses() {
        return null == this.handshakeSession ? Collections.emptyList() : this.handshakeSession.getStatusResponses();
    }
}

