/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.util;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.util.SetHostSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class URLConnectionUtil {
    protected final SSLSocketFactory sslSocketFactory;

    public URLConnectionUtil() {
        this(null);
    }

    public URLConnectionUtil(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public URLConnection openConnection(URL uRL) throws IOException {
        return this.configureConnection(uRL, uRL.openConnection());
    }

    public URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        return this.configureConnection(uRL, uRL.openConnection(proxy));
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        return this.openConnection(uRL).getInputStream();
    }

    public InputStream openStream(URL uRL) throws IOException {
        return this.openConnection(uRL).getInputStream();
    }

    protected URLConnection configureConnection(URL uRL, URLConnection uRLConnection) {
        if (!(uRLConnection instanceof HttpsURLConnection)) {
            return uRLConnection;
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
        if (null == sSLSocketFactory) {
            sSLSocketFactory = httpsURLConnection.getSSLSocketFactory();
        }
        httpsURLConnection.setSSLSocketFactory(this.createSSLSocketFactory(sSLSocketFactory, uRL));
        return httpsURLConnection;
    }

    protected SSLSocketFactory createSSLSocketFactory(SSLSocketFactory sSLSocketFactory, URL uRL) {
        return new SetHostSocketFactory(sSLSocketFactory, uRL);
    }
}

