/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pkcs.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CipherParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ExtendedDigest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.io.CipherInputStream;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.GenericKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.InputDecryptor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.InputDecryptorProvider;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(algorithmIdentifier, PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

