/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceKeyGenerationParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceKeyPairGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McEliecePublicKeyParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = (McElieceKeyGenParameterSpec)algorithmParameterSpec;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(secureRandom, new McElieceParameters(mcElieceKeyGenParameterSpec.getM(), mcElieceKeyGenParameterSpec.getT()));
        this.kpg.init(mcElieceKeyGenerationParameters);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(mcElieceKeyGenParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McEliecePublicKeyParameters mcEliecePublicKeyParameters = (McEliecePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(mcEliecePublicKeyParameters), new BCMcEliecePrivateKey(mcEliecePrivateKeyParameters));
    }
}

