/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.picnic;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Set;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.interfaces.PicnicKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.spec.PicnicParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCPicnicPrivateKey
implements PrivateKey,
PicnicKey {
    private static final long serialVersionUID = 1L;
    private transient PicnicPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCPicnicPrivateKey(PicnicPrivateKeyParameters picnicPrivateKeyParameters) {
        this.params = picnicPrivateKeyParameters;
    }

    public BCPicnicPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (PicnicPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCPicnicPrivateKey) {
            BCPicnicPrivateKey bCPicnicPrivateKey = (BCPicnicPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCPicnicPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "Picnic";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public PicnicParameterSpec getParameterSpec() {
        return PicnicParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    PicnicPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

