/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSReplayWindow;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCipher;
import java.io.IOException;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private final int recordHeaderLengthRead;
    private final int recordHeaderLengthWrite;
    private long sequenceNumber = 0L;

    DTLSEpoch(int n, TlsCipher tlsCipher, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (tlsCipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = n;
        this.cipher = tlsCipher;
        this.recordHeaderLengthRead = n2;
        this.recordHeaderLengthWrite = n3;
    }

    synchronized long allocateSequenceNumber() throws IOException {
        if (this.sequenceNumber >= 0x1000000000000L) {
            throw new TlsFatalAlert(80);
        }
        return this.sequenceNumber++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    int getRecordHeaderLengthRead() {
        return this.recordHeaderLengthRead;
    }

    int getRecordHeaderLengthWrite() {
        return this.recordHeaderLengthWrite;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    synchronized long getSequenceNumber() {
        return this.sequenceNumber;
    }

    synchronized void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }
}

