/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSRecordCallback;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSRecordLayer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramTransport;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import java.io.IOException;
import java.io.InterruptedIOException;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    @Override
    public int receive(byte[] byArray, int n, int n2, int n3) throws IOException {
        return this.receive(byArray, n, n2, n3, null);
    }

    public int receive(byte[] byArray, int n, int n2, int n3, DTLSRecordCallback dTLSRecordCallback) throws IOException {
        if (null == byArray) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + n);
        }
        if (n2 < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("'len' is an invalid length: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        try {
            return this.recordLayer.receive(byArray, n, n2, n3, dTLSRecordCallback);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (20 == tlsFatalAlert.getAlertDescription()) {
                return -1;
            }
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    public int receivePending(byte[] byArray, int n, int n2) throws IOException {
        return this.receivePending(byArray, n, n2, null);
    }

    public int receivePending(byte[] byArray, int n, int n2, DTLSRecordCallback dTLSRecordCallback) throws IOException {
        if (null == byArray) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + n);
        }
        if (n2 < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("'len' is an invalid length: " + n2);
        }
        try {
            return this.recordLayer.receivePending(byArray, n, n2, dTLSRecordCallback);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (20 == tlsFatalAlert.getAlertDescription()) {
                return -1;
            }
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void send(byte[] byArray, int n, int n2) throws IOException {
        if (null == byArray) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + n);
        }
        if (n2 < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("'len' is an invalid length: " + n2);
        }
        try {
            this.recordLayer.send(byArray, n, n2);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void close() throws IOException {
        this.recordLayer.close();
    }
}

