/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ClientHello;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSRecordLayer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSReliableHandshake;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSRequest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramSender;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsHMAC;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsMACOutputStream;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DTLSVerifier {
    private final TlsCrypto crypto;
    private final byte[] macKey;

    public DTLSVerifier(TlsCrypto tlsCrypto) {
        this.crypto = tlsCrypto;
        this.macKey = new byte[32];
        tlsCrypto.getSecureRandom().nextBytes(this.macKey);
    }

    public DTLSRequest verifyRequest(byte[] byArray, byte[] byArray2, int n, int n2, DatagramSender datagramSender) {
        try {
            int n3 = DTLSRecordLayer.receiveClientHelloRecord(byArray2, n, n2);
            if (n3 < 0) {
                return null;
            }
            int n4 = n3 - 12;
            if (n4 < 39) {
                return null;
            }
            int n5 = n + 13;
            ByteArrayInputStream byteArrayInputStream = DTLSReliableHandshake.receiveClientHelloMessage(byArray2, n5, n3);
            if (byteArrayInputStream == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
            ClientHello clientHello = ClientHello.parse(byteArrayInputStream, byteArrayOutputStream);
            if (clientHello == null) {
                return null;
            }
            long l = TlsUtils.readUint48(byArray2, n + 5);
            byte[] byArray3 = clientHello.getCookie();
            TlsHMAC tlsHMAC = this.crypto.createHMAC(3);
            tlsHMAC.setKey(this.macKey, 0, this.macKey.length);
            tlsHMAC.update(byArray, 0, byArray.length);
            byteArrayOutputStream.writeTo(new TlsMACOutputStream(tlsHMAC));
            byte[] byArray4 = tlsHMAC.calculateMAC();
            if (Arrays.constantTimeAreEqual(byArray4, byArray3)) {
                byte[] byArray5 = TlsUtils.copyOfRangeExact(byArray2, n5, n5 + n3);
                return new DTLSRequest(l, byArray5, clientHello);
            }
            DTLSReliableHandshake.sendHelloVerifyRequest(datagramSender, l, byArray4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

