/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentialedSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import java.io.IOException;

public class DefaultTlsCredentialedSigner
implements TlsCredentialedSigner {
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public DefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, TlsSigner tlsSigner, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (tlsSigner == null) {
            throw new IllegalArgumentException("'signer' cannot be null");
        }
        this.signer = tlsSigner;
        this.cryptoParams = tlsCryptoParameters;
        this.certificate = certificate;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] generateRawSignature(byte[] byArray) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), byArray);
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    @Override
    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (signatureAndHashAlgorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return signatureAndHashAlgorithm;
    }
}

