/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.HeartbeatMode;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatExtension {
    protected short mode;

    public HeartbeatExtension(short s2) {
        if (!HeartbeatMode.isValid(s2)) {
            throw new IllegalArgumentException("'mode' is not a valid HeartbeatMode value");
        }
        this.mode = s2;
    }

    public short getMode() {
        return this.mode;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.mode, outputStream);
    }

    public static HeartbeatExtension parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        if (!HeartbeatMode.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        return new HeartbeatExtension(s2);
    }
}

