/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.AbstractTlsServer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentials;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsPSKIdentityManager;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsCrypto tlsCrypto, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCrypto);
        this.pskIdentityManager = tlsPSKIdentityManager;
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (n) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsPSKIdentityManager getPSKIdentityManager() {
        return this.pskIdentityManager;
    }
}

