/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.AbstractTlsClient;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.BasicTlsSRPIdentity;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsAuthentication;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsExtensionsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsSRPIdentity;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsSRPUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{49182};
    protected TlsSRPIdentity srpIdentity;

    public SRPTlsClient(TlsCrypto tlsCrypto, byte[] byArray, byte[] byArray2) {
        this(tlsCrypto, new BasicTlsSRPIdentity(byArray, byArray2));
    }

    public SRPTlsClient(TlsCrypto tlsCrypto, TlsSRPIdentity tlsSRPIdentity) {
        super(tlsCrypto);
        this.srpIdentity = tlsSRPIdentity;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.srpIdentity.getSRPIdentity());
        return hashtable;
    }

    @Override
    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(hashtable, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(hashtable);
    }

    @Override
    public TlsSRPIdentity getSRPIdentity() {
        return this.srpIdentity;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

