/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentials;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsDHGroupVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsDHUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 11: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHanonKeyExchange(int n, TlsDHGroupVerifier tlsDHGroupVerifier) {
        this(n, tlsDHGroupVerifier, null);
    }

    public TlsDHanonKeyExchange(int n, TlsDHConfig tlsDHConfig) {
        this(n, null, tlsDHConfig);
    }

    private TlsDHanonKeyExchange(int n, TlsDHGroupVerifier tlsDHGroupVerifier, TlsDHConfig tlsDHConfig) {
        super(TlsDHanonKeyExchange.checkKeyExchange(n));
        this.dhGroupVerifier = tlsDHGroupVerifier;
        this.dhConfig = tlsDHConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsDHUtils.writeDHConfig(this.dhConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    @Override
    public void processClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

