/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.NamedGroup;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsContext;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsECCUtils {
    public static TlsECConfig createNamedECConfig(TlsContext tlsContext, int n) throws IOException {
        if (NamedGroup.getCurveBits(n) < 1) {
            throw new TlsFatalAlert(80);
        }
        return new TlsECConfig(n);
    }

    public static int getMinimumCurveBits(int n) {
        return TlsECCUtils.isECCCipherSuite(n) ? 1 : 0;
    }

    public static boolean isECCCipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static void checkPointEncoding(int n, byte[] byArray) throws IOException {
        if (TlsUtils.isNullOrEmpty(byArray)) {
            throw new TlsFatalAlert(47);
        }
        switch (n) {
            case 29: 
            case 30: {
                return;
            }
        }
        switch (byArray[0]) {
            case 4: {
                return;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig receiveECDHConfig(TlsContext tlsContext, InputStream inputStream) throws IOException {
        int[] nArray;
        short s2 = TlsUtils.readUint8(inputStream);
        if (s2 != 3) {
            throw new TlsFatalAlert(40);
        }
        int n = TlsUtils.readUint16(inputStream);
        if (NamedGroup.refersToAnECDHCurve(n) && (null == (nArray = tlsContext.getSecurityParametersHandshake().getClientSupportedGroups()) || Arrays.contains(nArray, n))) {
            return new TlsECConfig(n);
        }
        throw new TlsFatalAlert(47);
    }

    public static void writeECConfig(TlsECConfig tlsECConfig, OutputStream outputStream) throws IOException {
        TlsECCUtils.writeNamedECParameters(tlsECConfig.getNamedGroup(), outputStream);
    }

    public static void writeNamedECParameters(int n, OutputStream outputStream) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(n)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, outputStream);
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
    }
}

