/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SecurityParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;

public class TlsImplUtils {
    public static boolean isSSL(TlsCryptoParameters tlsCryptoParameters) {
        return tlsCryptoParameters.getServerVersion().isSSL();
    }

    public static boolean isTLSv10(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv10(tlsCryptoParameters.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv11(tlsCryptoParameters.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv12(tlsCryptoParameters.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv13(tlsCryptoParameters.getServerVersion());
    }

    public static byte[] calculateKeyBlock(TlsCryptoParameters tlsCryptoParameters, int n) {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        int n2 = securityParameters.getPRFAlgorithm();
        byte[] byArray = Arrays.concatenate(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        return tlsSecret.deriveUsingPRF(n2, "key expansion", byArray, n).extract();
    }
}

