/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.tls.TlsRsaKeyExchange;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import java.io.IOException;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto bcTlsCrypto, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (bcTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(asymmetricKeyParameter instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.crypto = bcTlsCrypto;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters tlsCryptoParameters, byte[] byArray) throws IOException {
        return this.safeDecryptPreMasterSecret(tlsCryptoParameters, (RSAKeyParameters)this.privateKey, byArray);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters tlsCryptoParameters, RSAKeyParameters rSAKeyParameters, byte[] byArray) {
        ProtocolVersion protocolVersion = tlsCryptoParameters.getRSAPreMasterSecretVersion();
        byte[] byArray2 = TlsRsaKeyExchange.decryptPreMasterSecret(byArray, 0, byArray.length, rSAKeyParameters, protocolVersion.getFullVersion(), this.crypto.getSecureRandom());
        return this.crypto.createSecret(byArray2);
    }
}

