/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static BcTlsCertificate getEndEntity(BcTlsCrypto bcTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return BcTlsCertificate.convert(bcTlsCrypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner bcTlsSigner;
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters;
            int n;
            RSAKeyParameters rSAKeyParameters2 = (RSAKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsRSAPSSSigner(bcTlsCrypto, rSAKeyParameters2, n);
            }
            try {
                rSAKeyParameters = BcDefaultTlsCredentialedSigner.getEndEntity(bcTlsCrypto, certificate).getPubKeyRSA();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            bcTlsSigner = new BcTlsRSASigner(bcTlsCrypto, rSAKeyParameters2, rSAKeyParameters);
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            bcTlsSigner = new BcTlsDSASigner(bcTlsCrypto, (DSAPrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            int n;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(n = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsECDSA13Signer(bcTlsCrypto, eCPrivateKeyParameters, n);
            }
            bcTlsSigner = new BcTlsECDSASigner(bcTlsCrypto, eCPrivateKeyParameters);
        } else if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd25519Signer(bcTlsCrypto, (Ed25519PrivateKeyParameters)asymmetricKeyParameter);
        } else if (asymmetricKeyParameter instanceof Ed448PrivateKeyParameters) {
            bcTlsSigner = new BcTlsEd448Signer(bcTlsCrypto, (Ed448PrivateKeyParameters)asymmetricKeyParameter);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        return bcTlsSigner;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, BcDefaultTlsCredentialedSigner.makeSigner(bcTlsCrypto, asymmetricKeyParameter, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

