/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.DSA;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.digests.NullDigest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.DSADigestSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public abstract class BcTlsDSSSigner
extends BcTlsSigner {
    protected BcTlsDSSSigner(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(bcTlsCrypto, asymmetricKeyParameter);
    }

    protected abstract DSA createDSAImpl(int var1);

    protected abstract short getSignatureAlgorithm();

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = null == signatureAndHashAlgorithm ? 2 : TlsCryptoUtils.getHash(signatureAndHashAlgorithm.getHash());
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(n), new NullDigest());
        dSADigestSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        if (signatureAndHashAlgorithm == null) {
            dSADigestSigner.update(byArray, 16, 20);
        } else {
            dSADigestSigner.update(byArray, 0, byArray.length);
        }
        try {
            return dSADigestSigner.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
    }
}

